/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.nni;

import nni.BLAS;
import org.carrot2.matrix.NNIDenseDoubleMatrix2D;
import org.carrot2.matrix.nni.IBlasOperations;

public final class BlasImpl
implements IBlasOperations {
    private static boolean initialized;

    private static synchronized void lazyInit() {
        if (initialized) {
            return;
        }
        BLAS.init();
        initialized = true;
    }

    public BlasImpl() {
        BlasImpl.lazyInit();
    }

    public void gemm(NNIDenseDoubleMatrix2D A, NNIDenseDoubleMatrix2D B, NNIDenseDoubleMatrix2D C, boolean transposeA, boolean transposeB, int columnsA, double alpha, int columns, double beta) {
        double[] dataA = A.getData();
        double[] dataB = B.getData();
        double[] dataC = C.getData();
        BLAS.gemm((int)101, (int)(transposeA ? 112 : 111), (int)(transposeB ? 112 : 111), (int)C.rows(), (int)C.columns(), (int)columnsA, (double)alpha, (double[])dataA, (int)Math.max(1, columns), (double[])dataB, (int)Math.max(1, B.columns()), (double)beta, (double[])dataC, (int)Math.max(1, C.columns()));
    }
}

