/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.view.designer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mobylet.core.Carrier;
import org.mobylet.core.Mobylet;
import org.mobylet.core.MobyletFactory;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.config.enums.JSession;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.util.UrlUtils;
import org.mobylet.view.config.TransitionConfig;
import org.mobylet.view.designer.SingletonDesigner;

public abstract class TransitionDesigner
extends SingletonDesigner {
    public static TransitionConfig config = new TransitionConfig();

    protected String constructUrl(String url) {
        return this.constructUrl(url, config);
    }

    protected String constructUrl(String url, TransitionConfig config) {
        Entry optionalEntry;
        String sessionId;
        if (url == null) {
            url = "";
        }
        if (config.isAdditionalContext() && url.startsWith("/")) {
            url = RequestUtils.get().getContextPath() + url;
        }
        if (StringUtils.isNotEmpty(sessionId = this.getSessionId(config))) {
            url = UrlUtils.addSession(url, sessionId);
        }
        if ((optionalEntry = this.getOptionalEntry(url, config)) != null) {
            url = UrlUtils.addParameter(url, optionalEntry.getKey(), optionalEntry.getValue());
        }
        return url;
    }

    protected String getSessionId() {
        return this.getSessionId(config);
    }

    protected String getSessionId(TransitionConfig config) {
        MobyletConfig mobyletConfig = SingletonUtils.get(MobyletConfig.class);
        if (mobyletConfig.getJSession() == JSession.NONE || mobyletConfig.getJSession() == JSession.USE_COOKIE) {
            return null;
        }
        Mobylet m = MobyletFactory.getInstance();
        HttpServletRequest request = RequestUtils.get();
        HttpSession session = request.getSession(false);
        if (session != null && (!config.isSessionCookiePriority() || config.isSessionCookiePriority() && !m.hasCookies())) {
            return session.getId();
        }
        return null;
    }

    protected Entry getOptionalEntry(String url) {
        return this.getOptionalEntry(url, config);
    }

    protected Entry getOptionalEntry(String url, TransitionConfig config) {
        Mobylet m = MobyletFactory.getInstance();
        HttpServletRequest request = RequestUtils.get();
        if (config.isUidOrGuidQueryRequiredInSecure() && m.getCarrier() == Carrier.DOCOMO && (url.startsWith("https:") || !url.startsWith("http:") && request.isSecure())) {
            String id = m.getUid();
            if (StringUtils.isNotEmpty(id)) {
                return new Entry("uid", id);
            }
            id = m.getGuid();
            if (StringUtils.isNotEmpty(id)) {
                return new Entry("guid", id);
            }
        } else {
            if (config.isUidQueryRequired() && m.getCarrier() == Carrier.DOCOMO && (url.startsWith("http:") || !url.startsWith("https:") && !request.isSecure())) {
                return new Entry("uid", "NULLGWDOCOMO");
            }
            if (config.isGuidQueryRequired() && m.getCarrier() == Carrier.DOCOMO && (url.startsWith("http:") || !url.startsWith("https:") && !request.isSecure())) {
                return new Entry("guid", "ON");
            }
        }
        return null;
    }

    public static class Entry {
        protected String key;
        protected String value;

        public Entry() {
        }

        public Entry(String k, String v) {
            this.key = k;
            this.value = v;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

