/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import org.mobylet.core.Carrier;
import org.mobylet.core.emoji.EmojiPoolFamily;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class EmojiUtils {
    public static String replaceEmoji(String src, String replace) {
        if (StringUtils.isEmpty(src)) {
            return null;
        }
        if (replace == null) {
            replace = "";
        }
        EmojiPoolFamily family = SingletonUtils.get(EmojiPoolFamily.class);
        StringBuilder sb = new StringBuilder();
        for (char c : src.toCharArray()) {
            if (family.isEmoji(c)) {
                sb.append(replace);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String removeEmoji(String src) {
        return EmojiUtils.replaceEmoji(src, "");
    }

    public static String getEmoji(String name) {
        return EmojiUtils.getEmoji(name, Carrier.DOCOMO);
    }

    public static String getEmoji(String name, Carrier carrier) {
        EmojiPoolFamily family = SingletonUtils.get(EmojiPoolFamily.class);
        return new String(family.getEmojiPool(carrier).get(name).getCodes());
    }
}

