/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.handler.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.seasar.chronos.core.TaskScheduleEntry;
import org.seasar.chronos.core.handler.impl.AbstractScheduleExecuteHandler;
import org.seasar.chronos.core.impl.SchedulerImpl;
import org.seasar.chronos.core.impl.TaskStateType;
import org.seasar.chronos.core.schedule.TaskScheduleEntryManager;
import org.seasar.chronos.core.task.TaskExecutorService;

public class ScheduleExecuteShutdownHandler
extends AbstractScheduleExecuteHandler {
    public void handleRequest() throws InterruptedException {
        this.taskScheduleEntryManager.forEach(TaskStateType.RUNNING, new TaskScheduleEntryManager.TaskScheduleEntryHanlder(){

            public Object processTaskScheduleEntry(final TaskScheduleEntry taskScheduleEntry) {
                final TaskExecutorService tes = taskScheduleEntry.getTaskExecutorService();
                if (tes.getTaskPropertyReader().isShutdownTask(false)) {
                    AbstractScheduleExecuteHandler.log.log("DCHRONOS0011", new Object[]{tes.getTaskPropertyReader().getTaskName(null)});
                    Future<TaskExecutorService> future = ScheduleExecuteShutdownHandler.this.executorService.submit(new Callable<TaskExecutorService>(){

                        @Override
                        public TaskExecutorService call() throws Exception {
                            Object[] logArgs = new Object[]{tes.getTaskPropertyReader().getTaskName(null)};
                            AbstractScheduleExecuteHandler.log.log("DCHRONOS0002", logArgs);
                            AbstractScheduleExecuteHandler.log.log("DCHRONOS0012", logArgs);
                            if (tes.cancel()) {
                                while (!tes.await(10L, SchedulerImpl.SHUTDOWN_AWAIT_TIMEUNIT)) {
                                    AbstractScheduleExecuteHandler.log.log("DCHRONOS0013", logArgs);
                                }
                                ScheduleExecuteShutdownHandler.this.schedulerEventHandler.fireCancelTask(tes.getTask());
                                ScheduleExecuteShutdownHandler.this.taskScheduleEntryManager.removeTaskScheduleEntry(TaskStateType.CANCELING, taskScheduleEntry);
                                ScheduleExecuteShutdownHandler.this.taskScheduleEntryManager.addTaskScheduleEntry(TaskStateType.UNSCHEDULED, taskScheduleEntry);
                            } else {
                                AbstractScheduleExecuteHandler.log.debug((Object)"cancel error!");
                            }
                            AbstractScheduleExecuteHandler.log.log("DCHRONOS0014", logArgs);
                            AbstractScheduleExecuteHandler.log.log("DCHRONOS0003", new Object[]{tes.getTaskPropertyReader().getTaskName(null)});
                            return tes;
                        }
                    });
                    taskScheduleEntry.setTaskStaterFuture(future);
                    ScheduleExecuteShutdownHandler.this.taskScheduleEntryManager.addTaskScheduleEntry(TaskStateType.CANCELING, taskScheduleEntry);
                    ScheduleExecuteShutdownHandler.this.taskScheduleEntryManager.removeTaskScheduleEntry(TaskStateType.RUNNING, taskScheduleEntry);
                }
                return null;
            }
        });
    }
}

