/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.decomposer.EigenStatus;
import org.apache.mahout.math.decomposer.SimpleEigenVerifier;

public class AsyncEigenVerifier
extends SimpleEigenVerifier {
    private final Executor threadPool = Executors.newFixedThreadPool(1);
    private EigenStatus status = new EigenStatus(-1.0, 0.0);
    private boolean finished = false;
    private boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EigenStatus verify(VectorIterable corpus, Vector vector) {
        EigenStatus eigenStatus = this.status;
        synchronized (eigenStatus) {
            if (!this.finished && !this.started) {
                this.status = new EigenStatus(-1.0, 0.0);
                Vector vectorCopy = vector.clone();
                this.threadPool.execute(new VerifierRunnable(corpus, vectorCopy));
                this.started = true;
            }
            if (this.finished) {
                this.finished = false;
            }
            return this.status;
        }
    }

    protected EigenStatus innerVerify(VectorIterable corpus, Vector vector) {
        return super.verify(corpus, vector);
    }

    private class VerifierRunnable
    implements Runnable {
        private final VectorIterable corpus;
        private final Vector vector;

        protected VerifierRunnable(VectorIterable corpus, Vector vector) {
            this.corpus = corpus;
            this.vector = vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EigenStatus status = AsyncEigenVerifier.this.innerVerify(this.corpus, this.vector);
            EigenStatus eigenStatus = AsyncEigenVerifier.this.status;
            synchronized (eigenStatus) {
                AsyncEigenVerifier.this.status = status;
                AsyncEigenVerifier.this.finished = true;
                AsyncEigenVerifier.this.started = false;
            }
        }
    }
}

