/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialAccessSparseVector
extends AbstractVector {
    protected OrderedIntDoubleMapping values;

    public SequentialAccessSparseVector() {
        super(null, 0);
    }

    public SequentialAccessSparseVector(int cardinality, int size) {
        this(null, cardinality, size);
    }

    public SequentialAccessSparseVector(String name, int cardinality, int size) {
        super(name, cardinality);
        this.values = new OrderedIntDoubleMapping(size);
    }

    public SequentialAccessSparseVector(String name, int cardinality) {
        this(name, cardinality, cardinality / 8);
    }

    public SequentialAccessSparseVector(int cardinality) {
        this(null, cardinality, cardinality / 8);
    }

    public SequentialAccessSparseVector(Vector other) {
        this(other.getName(), other.size(), other.getNumNondefaultElements());
        Vector.Element e;
        Iterator<Vector.Element> it = other.iterateNonZero();
        while (it.hasNext() && (e = it.next()) != null) {
            this.set(e.index(), e.get());
        }
    }

    public SequentialAccessSparseVector(SequentialAccessSparseVector other, boolean shallowCopy) {
        super(other.getName(), other.size());
        this.values = shallowCopy ? other.values : other.values.clone();
    }

    public SequentialAccessSparseVector(SequentialAccessSparseVector other) {
        this(other.getName(), other.size(), other.getNumNondefaultElements());
        this.values = other.values.clone();
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        int[] cardinality = new int[]{rows, columns};
        return new SparseRowMatrix(cardinality);
    }

    @Override
    public SequentialAccessSparseVector clone() {
        SequentialAccessSparseVector clone = (SequentialAccessSparseVector)super.clone();
        clone.values = this.values.clone();
        return clone;
    }

    @Override
    public double getQuick(int index) {
        return this.values.get(index);
    }

    @Override
    public void setQuick(int index, double value) {
        this.lengthSquared = -1.0;
        this.values.set(index, value);
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.getNumMappings();
    }

    @Override
    public SequentialAccessSparseVector like() {
        int numValues = 256;
        if (this.values != null) {
            numValues = this.values.getNumMappings();
        }
        return new SequentialAccessSparseVector(this.size(), numValues);
    }

    @Override
    public Vector like(int newCardinality) {
        int numValues = 256;
        if (this.values != null) {
            numValues = this.values.getNumMappings();
        }
        return new SequentialAccessSparseVector(newCardinality, numValues);
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new IntDoublePairIterator(this);
    }

    @Override
    public Iterator<Vector.Element> iterateAll() {
        return new IntDoublePairIterator(this, this.size());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector that = (Vector)o;
        String thisName = this.getName();
        String thatName = that.getName();
        if (this.size() != that.size()) {
            return false;
        }
        if (thisName != null && thatName != null && !thisName.equals(thatName)) {
            return false;
        }
        if (thisName != null && thatName == null || thatName != null && thisName == null) {
            return false;
        }
        if (that instanceof SequentialAccessSparseVector) {
            return this.values == null ? ((SequentialAccessSparseVector)that).values == null : this.values.equals(((SequentialAccessSparseVector)that).values);
        }
        return SequentialAccessSparseVector.equivalent(this, that);
    }

    @Override
    public Vector.Element getElement(int index) {
        return new DenseElement(index, this);
    }

    @Override
    public double dot(Vector x) {
        if (this.size() != x.size()) {
            throw new CardinalityException(this.size(), x.size());
        }
        if (this == x) {
            return this.dotSelf();
        }
        double result = 0.0;
        if (x instanceof SequentialAccessSparseVector) {
            Iterator<Vector.Element> myIter = this.iterateNonZero();
            Iterator<Vector.Element> otherIter = x.iterateNonZero();
            Vector.Element myCurrent = null;
            Vector.Element otherCurrent = null;
            while (myIter.hasNext() && otherIter.hasNext()) {
                int otherIndex;
                int myIndex;
                if (myCurrent == null) {
                    myCurrent = myIter.next();
                }
                if (otherCurrent == null) {
                    otherCurrent = otherIter.next();
                }
                if ((myIndex = myCurrent.index()) < (otherIndex = otherCurrent.index())) {
                    myCurrent = null;
                    continue;
                }
                if (myIndex > otherIndex) {
                    otherCurrent = null;
                    continue;
                }
                result += myCurrent.get() * otherCurrent.get();
                myCurrent = null;
                otherCurrent = null;
            }
            return result;
        }
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            result += element.get() * x.getQuick(element.index());
        }
        return result;
    }

    private static final class SparseElement
    extends AbstractElement {
        private final SequentialAccessSparseVector v;

        SparseElement(int ind, SequentialAccessSparseVector v) {
            super(ind, v);
            this.v = v;
        }

        public double get() {
            return this.values[this.offset];
        }

        public int index() {
            return this.indices[this.offset];
        }

        public void set(double value) {
            this.v.lengthSquared = -1.0;
            this.values[this.offset] = value;
        }
    }

    private static final class DenseElement
    extends AbstractElement {
        private int index;
        private final SequentialAccessSparseVector v;

        DenseElement(int ind, SequentialAccessSparseVector v) {
            super(ind, v);
            this.v = v;
            this.index = ind;
        }

        public double get() {
            if (this.index >= this.indices.length) {
                return 0.0;
            }
            int cur = this.indices[this.index];
            while (cur < this.offset && this.index < this.indices.length - 1) {
                cur = this.indices[++this.index];
            }
            if (cur == this.offset) {
                return this.values[this.index];
            }
            return 0.0;
        }

        public int index() {
            return this.offset;
        }

        public void set(double value) {
            this.v.set(this.offset, value);
            this.indices = this.mapping.getIndices();
            this.values = this.mapping.getValues();
        }
    }

    private static abstract class AbstractElement
    implements Vector.Element {
        int offset;
        final OrderedIntDoubleMapping mapping;
        int[] indices;
        double[] values;

        AbstractElement(int ind, SequentialAccessSparseVector v) {
            this.offset = ind;
            this.mapping = v.values;
            this.values = this.mapping.getValues();
            this.indices = this.mapping.getIndices();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntDoublePairIterator
    implements Iterator<Vector.Element> {
        private int offset = 0;
        private final AbstractElement element;
        private final int maxOffset;

        IntDoublePairIterator(SequentialAccessSparseVector v) {
            this.element = new SparseElement(this.offset, v);
            this.maxOffset = v.values.getNumMappings();
        }

        IntDoublePairIterator(SequentialAccessSparseVector v, int cardinality) {
            this.element = new DenseElement(this.offset, v);
            this.maxOffset = cardinality;
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.maxOffset;
        }

        @Override
        public Vector.Element next() {
            if (this.offset >= this.maxOffset) {
                throw new NoSuchElementException();
            }
            this.element.offset = this.offset++;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

