/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import org.apache.mahout.math.JsonVectorAdapter;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonMatrixAdapter
implements JsonSerializer<Matrix>,
JsonDeserializer<Matrix> {
    private static final Logger log = LoggerFactory.getLogger(JsonMatrixAdapter.class);
    public static final String CLASS = "class";
    public static final String MATRIX = "matrix";

    public JsonElement serialize(Matrix src, Type typeOfSrc, JsonSerializationContext context) {
        Type vectorType = new TypeToken<Vector>(){}.getType();
        Type matrixType = new TypeToken<Matrix>(){}.getType();
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(vectorType, (Object)new JsonVectorAdapter());
        builder.registerTypeAdapter(matrixType, (Object)new JsonMatrixAdapter());
        Gson gson = builder.create();
        JsonObject obj = new JsonObject();
        obj.add(CLASS, (JsonElement)new JsonPrimitive(src.getClass().getName()));
        obj.add(MATRIX, (JsonElement)new JsonPrimitive(gson.toJson((Object)src)));
        return obj;
    }

    public Matrix deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Type vectorType = new TypeToken<Vector>(){}.getType();
        Type matrixType = new TypeToken<Matrix>(){}.getType();
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(vectorType, (Object)new JsonVectorAdapter());
        builder.registerTypeAdapter(matrixType, (Object)new JsonMatrixAdapter());
        Gson gson = builder.create();
        JsonObject obj = json.getAsJsonObject();
        String klass = obj.get(CLASS).getAsString();
        String matrix = obj.get(MATRIX).getAsString();
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Class<?> cl = null;
        try {
            cl = ccl.loadClass(klass);
        }
        catch (ClassNotFoundException e) {
            log.warn("Error while loading class", (Throwable)e);
        }
        return (Matrix)gson.fromJson(matrix, cl);
    }
}

