/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.tika.metadata.ClimateForcast;
import org.apache.tika.metadata.CreativeCommons;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Geographic;
import org.apache.tika.metadata.HttpHeaders;
import org.apache.tika.metadata.IPTC;
import org.apache.tika.metadata.MSOffice;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.PropertyTypeException;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.TikaMetadataKeys;
import org.apache.tika.metadata.TikaMimeKeys;

public class Metadata
implements CreativeCommons,
DublinCore,
Geographic,
HttpHeaders,
IPTC,
Message,
MSOffice,
ClimateForcast,
TIFF,
TikaMetadataKeys,
TikaMimeKeys,
Serializable {
    private static final long serialVersionUID = 5623926545693153182L;
    private Map<String, String[]> metadata = new HashMap<String, String[]>();
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final TimeZone MIDDAY = TimeZone.getTimeZone("GMT-12:00");
    private static final DateFormat[] iso8601InputFormats = new DateFormat[]{Metadata.createDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", UTC), Metadata.createDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", null), Metadata.createDateFormat("yyyy-MM-dd'T'HH:mm:ss", null), Metadata.createDateFormat("yyyy-MM-dd' 'HH:mm:ss'Z'", UTC), Metadata.createDateFormat("yyyy-MM-dd' 'HH:mm:ssZ", null), Metadata.createDateFormat("yyyy-MM-dd' 'HH:mm:ss", null), Metadata.createDateFormat("yyyy-MM-dd", MIDDAY), Metadata.createDateFormat("yyyy:MM:dd", MIDDAY)};

    private static DateFormat createDateFormat(String format, TimeZone timezone) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, new DateFormatSymbols(Locale.US));
        if (timezone != null) {
            sdf.setTimeZone(timezone);
        }
        return sdf;
    }

    private static synchronized Date parseDate(String date) {
        int n = date.length();
        if (date.charAt(n - 3) == ':' && (date.charAt(n - 6) == '+' || date.charAt(n - 6) == '-')) {
            date = date.substring(0, n - 3) + date.substring(n - 2);
        }
        for (DateFormat format : iso8601InputFormats) {
            try {
                return format.parse(date);
            }
            catch (ParseException ignore) {
            }
        }
        return null;
    }

    private static String formatDate(Date date) {
        Calendar calendar = GregorianCalendar.getInstance(UTC, Locale.US);
        calendar.setTime(date);
        return String.format("%04d-%02d-%02dT%02d:%02d:%02dZ", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public boolean isMultiValued(String name) {
        return this.metadata.get(name) != null && this.metadata.get(name).length > 1;
    }

    public String[] names() {
        return this.metadata.keySet().toArray(new String[this.metadata.keySet().size()]);
    }

    public String get(String name) {
        String[] values = this.metadata.get(name);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public String get(Property property) {
        return this.get(property.getName());
    }

    public Integer getInt(Property property) {
        if (property.getPropertyType() != Property.PropertyType.SIMPLE) {
            return null;
        }
        if (property.getValueType() != Property.ValueType.INTEGER) {
            return null;
        }
        String v = this.get(property);
        if (v == null) {
            return null;
        }
        try {
            return Integer.valueOf(v);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Date getDate(Property property) {
        if (property.getPropertyType() != Property.PropertyType.SIMPLE) {
            return null;
        }
        if (property.getValueType() != Property.ValueType.DATE) {
            return null;
        }
        String v = this.get(property);
        if (v != null) {
            return Metadata.parseDate(v);
        }
        return null;
    }

    public String[] getValues(String name) {
        return this._getValues(name);
    }

    private String[] _getValues(String name) {
        String[] values = this.metadata.get(name);
        if (values == null) {
            values = new String[]{};
        }
        return values;
    }

    public void add(String name, String value) {
        String[] values = this.metadata.get(name);
        if (values == null) {
            this.set(name, value);
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            this.metadata.put(name, newValues);
        }
    }

    public void setAll(Properties properties) {
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.metadata.put(name, new String[]{properties.getProperty(name)});
        }
    }

    public void set(String name, String value) {
        this.metadata.put(name, new String[]{value});
    }

    public void set(Property property, String value) {
        this.set(property.getName(), value);
    }

    public void set(Property property, int value) {
        if (property.getPropertyType() != Property.PropertyType.SIMPLE) {
            throw new PropertyTypeException(Property.PropertyType.SIMPLE, property.getPropertyType());
        }
        if (property.getValueType() != Property.ValueType.INTEGER) {
            throw new PropertyTypeException(Property.ValueType.INTEGER, property.getValueType());
        }
        this.set(property.getName(), Integer.toString(value));
    }

    public void set(Property property, double value) {
        if (property.getPropertyType() != Property.PropertyType.SIMPLE) {
            throw new PropertyTypeException(Property.PropertyType.SIMPLE, property.getPropertyType());
        }
        if (property.getValueType() != Property.ValueType.REAL && property.getValueType() != Property.ValueType.RATIONAL) {
            throw new PropertyTypeException(Property.ValueType.REAL, property.getValueType());
        }
        this.set(property.getName(), Double.toString(value));
    }

    public void set(Property property, Date date) {
        if (property.getPropertyType() != Property.PropertyType.SIMPLE) {
            throw new PropertyTypeException(Property.PropertyType.SIMPLE, property.getPropertyType());
        }
        if (property.getValueType() != Property.ValueType.DATE) {
            throw new PropertyTypeException(Property.ValueType.DATE, property.getValueType());
        }
        this.set(property.getName(), Metadata.formatDate(date));
    }

    public void remove(String name) {
        this.metadata.remove(name);
    }

    public int size() {
        return this.metadata.size();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Metadata other = null;
        try {
            other = (Metadata)o;
        }
        catch (ClassCastException cce) {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        String[] names = this.names();
        for (int i = 0; i < names.length; ++i) {
            String[] thisValues;
            String[] otherValues = other._getValues(names[i]);
            if (otherValues.length != (thisValues = this._getValues(names[i])).length) {
                return false;
            }
            for (int j = 0; j < otherValues.length; ++j) {
                if (otherValues[j].equals(thisValues[j])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String[] names = this.names();
        for (int i = 0; i < names.length; ++i) {
            String[] values = this._getValues(names[i]);
            for (int j = 0; j < values.length; ++j) {
                buf.append(names[i]).append("=").append(values[j]).append(" ");
            }
        }
        return buf.toString();
    }
}

