/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.collector.FilterCollector;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCommand
implements Command<QueryCommandResult> {
    private final Sort sort;
    private final Query query;
    private final DocSet docSet;
    private final int docsToCollect;
    private final boolean needScores;
    private final String queryString;
    private TopDocsCollector collector;
    private FilterCollector filterCollector;

    private QueryCommand(Sort sort, Query query, int docsToCollect, boolean needScores, DocSet docSet, String queryString) {
        this.sort = sort;
        this.query = query;
        this.docsToCollect = docsToCollect;
        this.needScores = needScores;
        this.docSet = docSet;
        this.queryString = queryString;
    }

    @Override
    public List<Collector> create() throws IOException {
        this.collector = this.sort == null || this.sort == Sort.RELEVANCE ? TopScoreDocCollector.create((int)this.docsToCollect, (boolean)true) : TopFieldCollector.create((Sort)this.sort, (int)this.docsToCollect, (boolean)true, (boolean)this.needScores, (boolean)this.needScores, (boolean)true);
        this.filterCollector = new FilterCollector(this.docSet, (Collector)this.collector);
        return Arrays.asList(new Collector[]{this.filterCollector});
    }

    @Override
    public QueryCommandResult result() {
        return new QueryCommandResult(this.collector.topDocs(), this.filterCollector.getMatches());
    }

    @Override
    public String getKey() {
        return this.queryString != null ? this.queryString : this.query.toString();
    }

    @Override
    public Sort getGroupSort() {
        return this.sort;
    }

    @Override
    public Sort getSortWithinGroup() {
        return null;
    }

    public static class Builder {
        private Sort sort;
        private String queryString;
        private Query query;
        private DocSet docSet;
        private Integer docsToCollect;
        private boolean needScores;

        public Builder setSort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public Builder setQuery(Query query) {
            this.query = query;
            return this;
        }

        public Builder setQuery(String groupQueryString, SolrQueryRequest request) throws ParseException {
            QParser parser = QParser.getParser(groupQueryString, null, request);
            this.queryString = groupQueryString;
            return this.setQuery(parser.getQuery());
        }

        public Builder setDocSet(DocSet docSet) {
            this.docSet = docSet;
            return this;
        }

        public Builder setDocSet(SolrIndexSearcher searcher) throws IOException {
            return this.setDocSet(searcher.getDocSet(this.query));
        }

        public Builder setDocsToCollect(int docsToCollect) {
            this.docsToCollect = docsToCollect;
            return this;
        }

        public Builder setNeedScores(boolean needScores) {
            this.needScores = needScores;
            return this;
        }

        public QueryCommand build() {
            if (this.sort == null || this.query == null || this.docSet == null || this.docsToCollect == null) {
                throw new IllegalStateException("All fields must be set");
            }
            return new QueryCommand(this.sort, this.query, this.docsToCollect, this.needScores, this.docSet, this.queryString);
        }
    }
}

