/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.MultiValueSource;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorValueSource
extends MultiValueSource {
    protected final List<ValueSource> sources;

    public VectorValueSource(List<ValueSource> sources) {
        this.sources = sources;
    }

    public List<ValueSource> getSources() {
        return this.sources;
    }

    @Override
    public int dimension() {
        return this.sources.size();
    }

    public String name() {
        return "vector";
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        int size = this.sources.size();
        if (size == 2) {
            final DocValues x = this.sources.get(0).getValues(context, reader);
            final DocValues y = this.sources.get(1).getValues(context, reader);
            return new DocValues(){

                public void byteVal(int doc, byte[] vals) {
                    vals[0] = x.byteVal(doc);
                    vals[1] = y.byteVal(doc);
                }

                public void shortVal(int doc, short[] vals) {
                    vals[0] = x.shortVal(doc);
                    vals[1] = y.shortVal(doc);
                }

                public void intVal(int doc, int[] vals) {
                    vals[0] = x.intVal(doc);
                    vals[1] = y.intVal(doc);
                }

                public void longVal(int doc, long[] vals) {
                    vals[0] = x.longVal(doc);
                    vals[1] = y.longVal(doc);
                }

                public void floatVal(int doc, float[] vals) {
                    vals[0] = x.floatVal(doc);
                    vals[1] = y.floatVal(doc);
                }

                public void doubleVal(int doc, double[] vals) {
                    vals[0] = x.doubleVal(doc);
                    vals[1] = y.doubleVal(doc);
                }

                public void strVal(int doc, String[] vals) {
                    vals[0] = x.strVal(doc);
                    vals[1] = y.strVal(doc);
                }

                public String toString(int doc) {
                    return VectorValueSource.this.name() + "(" + x.toString(doc) + "," + y.toString(doc) + ")";
                }
            };
        }
        final DocValues[] valsArr = new DocValues[size];
        for (int i = 0; i < size; ++i) {
            valsArr[i] = this.sources.get(i).getValues(context, reader);
        }
        return new DocValues(){

            public void byteVal(int doc, byte[] vals) {
                for (int i = 0; i < valsArr.length; ++i) {
                    vals[i] = valsArr[i].byteVal(doc);
                }
            }

            public void shortVal(int doc, short[] vals) {
                for (int i = 0; i < valsArr.length; ++i) {
                    vals[i] = valsArr[i].shortVal(doc);
                }
            }

            public void floatVal(int doc, float[] vals) {
                for (int i = 0; i < valsArr.length; ++i) {
                    vals[i] = valsArr[i].floatVal(doc);
                }
            }

            public void intVal(int doc, int[] vals) {
                for (int i = 0; i < valsArr.length; ++i) {
                    vals[i] = valsArr[i].intVal(doc);
                }
            }

            public void longVal(int doc, long[] vals) {
                for (int i = 0; i < valsArr.length; ++i) {
                    vals[i] = valsArr[i].longVal(doc);
                }
            }

            public void doubleVal(int doc, double[] vals) {
                for (int i = 0; i < valsArr.length; ++i) {
                    vals[i] = valsArr[i].doubleVal(doc);
                }
            }

            public void strVal(int doc, String[] vals) {
                for (int i = 0; i < valsArr.length; ++i) {
                    vals[i] = valsArr[i].strVal(doc);
                }
            }

            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append(VectorValueSource.this.name()).append('(');
                boolean firstTime = true;
                for (DocValues vals : valsArr) {
                    if (firstTime) {
                        firstTime = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(vals.toString(doc));
                }
                sb.append(')');
                return sb.toString();
            }
        };
    }

    @Override
    public void createWeight(Map context, Searcher searcher) throws IOException {
        for (ValueSource source : this.sources) {
            source.createWeight(context, searcher);
        }
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(');
        boolean firstTime = true;
        for (ValueSource source : this.sources) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(',');
            }
            sb.append(source);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VectorValueSource)) {
            return false;
        }
        VectorValueSource that = (VectorValueSource)o;
        return ((Object)this.sources).equals(that.sources);
    }

    @Override
    public int hashCode() {
        return ((Object)this.sources).hashCode();
    }
}

