/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.handler.XMLLoader;
import org.apache.solr.handler.XsltUpdateRequestHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.xslt.TransformerProvider;
import org.xml.sax.InputSource;

class XsltXMLLoader
extends XMLLoader {
    public static final String TRANSFORM_PARAM = "tr";
    public static final String CONTEXT_TRANSFORMER_KEY = "xsltupdater.transformer";
    private final Integer xsltCacheLifetimeSeconds;

    public XsltXMLLoader(UpdateRequestProcessor processor, XMLInputFactory inputFactory, Integer xsltCacheLifetimeSeconds) {
        super(processor, inputFactory);
        this.xsltCacheLifetimeSeconds = xsltCacheLifetimeSeconds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream) throws Exception {
        DOMResult result = new DOMResult();
        Transformer t = this.getTransformer(req);
        InputStream is = null;
        XMLStreamReader parser = null;
        try {
            try {
                is = stream.getStream();
                String charset = ContentStreamBase.getCharsetFromContentType((String)stream.getContentType());
                InputSource isrc = new InputSource(is);
                isrc.setEncoding(charset);
                SAXSource source = new SAXSource(isrc);
                t.transform(source, result);
            }
            catch (TransformerException te) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, te.getMessage(), (Throwable)te);
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            IOUtils.closeQuietly((InputStream)is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        try {
            try {
                parser = this.inputFactory.createXMLStreamReader(new DOMSource(result.getNode()));
                this.processUpdate(this.processor, parser);
            }
            catch (XMLStreamException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
            }
            Object var14_16 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (parser == null) throw throwable;
            parser.close();
            throw throwable;
        }
        parser.close();
    }

    protected Transformer getTransformer(SolrQueryRequest request) throws IOException {
        String xslt = request.getParams().get(TRANSFORM_PARAM, null);
        if (xslt == null) {
            throw new IOException("'tr' request parameter is required to use the XSLTResponseWriter");
        }
        SolrConfig solrConfig = request.getCore().getSolrConfig();
        Map<Object, Object> ctx = request.getContext();
        Transformer result = (Transformer)ctx.get(CONTEXT_TRANSFORMER_KEY);
        if (result == null) {
            result = TransformerProvider.instance.getTransformer(solrConfig, xslt, this.xsltCacheLifetimeSeconds);
            result.setErrorListener((ErrorListener)XsltUpdateRequestHandler.xmllog);
            ctx.put(CONTEXT_TRANSFORMER_KEY, result);
        }
        return result;
    }
}

