/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.solr.analysis.CharFilterFactory;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerFactory;

public final class TokenizerChain
extends SolrAnalyzer {
    private final CharFilterFactory[] charFilters;
    private final TokenizerFactory tokenizer;
    private final TokenFilterFactory[] filters;

    public TokenizerChain(TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        this(null, tokenizer, filters);
    }

    public TokenizerChain(CharFilterFactory[] charFilters, TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        this.charFilters = charFilters;
        this.tokenizer = tokenizer;
        this.filters = filters;
    }

    public CharFilterFactory[] getCharFilterFactories() {
        return this.charFilters;
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.tokenizer;
    }

    public TokenFilterFactory[] getTokenFilterFactories() {
        return this.filters;
    }

    public Reader charStream(Reader reader) {
        if (this.charFilters != null && this.charFilters.length > 0) {
            CharStream cs = CharReader.get((Reader)reader);
            for (int i = 0; i < this.charFilters.length; ++i) {
                cs = this.charFilters[i].create(cs);
            }
            reader = cs;
        }
        return reader;
    }

    public SolrAnalyzer.TokenStreamInfo getStream(String fieldName, Reader reader) {
        Tokenizer tk;
        Tokenizer ts = tk = this.tokenizer.create(this.charStream(reader));
        for (int i = 0; i < this.filters.length; ++i) {
            ts = this.filters[i].create((TokenStream)ts);
        }
        return new SolrAnalyzer.TokenStreamInfo(tk, (TokenStream)ts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TokenizerChain(");
        for (CharFilterFactory charFilterFactory : this.charFilters) {
            sb.append(charFilterFactory);
            sb.append(", ");
        }
        sb.append(this.tokenizer);
        for (TokenFilterFactory tokenFilterFactory : this.filters) {
            sb.append(", ");
            sb.append(tokenFilterFactory);
        }
        sb.append(')');
        return sb.toString();
    }
}

