/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.transformer.impl;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.AccessResultData;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.ResultData;
import org.seasar.robot.extractor.Extractor;
import org.seasar.robot.extractor.ExtractorFactory;
import org.seasar.robot.transformer.impl.AbstractTransformer;

public class TextTransformer
extends AbstractTransformer {
    protected String charsetName = "UTF-8";

    public ResultData transform(ResponseData responseData) {
        if (responseData == null || responseData.getResponseBody() == null) {
            throw new RobotCrawlAccessException("No response body.");
        }
        ExtractorFactory extractorFactory = (ExtractorFactory)SingletonS2Container.getComponent((String)"extractorFactory");
        if (extractorFactory == null) {
            throw new RobotSystemException("Could not find extractorFactory.");
        }
        Extractor extractor = extractorFactory.getExtractor(responseData.getMimeType());
        InputStream in = responseData.getResponseBody();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resourceName", this.getResourceName(responseData));
        params.put("Content-Type", responseData.getMimeType());
        String content = null;
        try {
            try {
                content = extractor.getText(in, params).getContent();
            }
            catch (Exception e) {
                throw new RobotCrawlAccessException("Could not extract data.", e);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        ResultData resultData = new ResultData();
        resultData.setTransformerName(this.getName());
        try {
            resultData.setData(content.getBytes(this.charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new RobotCrawlAccessException("Unsupported encoding: " + this.charsetName, e);
        }
        resultData.setEncoding(this.charsetName);
        return resultData;
    }

    public Object getData(AccessResultData accessResultData) {
        if (!this.getName().equals(accessResultData.getTransformerName())) {
            throw new RobotSystemException("Transformer is invalid. Use " + accessResultData.getTransformerName() + ". This transformer is " + this.getName() + ".");
        }
        byte[] data = accessResultData.getData();
        if (data == null) {
            return null;
        }
        try {
            return new String(data, this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RobotCrawlAccessException("Unsupported encoding: " + this.charsetName, e);
        }
    }

    private String getResourceName(ResponseData responseData) {
        String name = responseData.getUrl();
        String enc = responseData.getCharSet();
        if (name == null || enc == null) {
            return null;
        }
        int idx = (name = name.replaceAll("/+$", "")).lastIndexOf("/");
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        try {
            return URLDecoder.decode(name, enc);
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }
}

