/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.launcher;

import java.nio.charset.Charset;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.config.xml.MobyletConfigXmlReader;
import org.mobylet.core.initializer.MobyletInitializer;
import org.mobylet.core.launcher.LaunchConfig;
import org.mobylet.core.log.MobyletLogger;
import org.mobylet.core.log.impl.LoggerImpl;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class MobyletLauncher {
    public static void launch() {
        LaunchConfig launchConfig = new LaunchConfig();
        MobyletLauncher.initSingletonContainer();
        MobyletLauncher.initLogger(launchConfig);
        MobyletLauncher.initDefaultCharset(launchConfig);
        MobyletLauncher.initInitializer(launchConfig);
    }

    public static void initSingletonContainer() {
        if (!SingletonUtils.isInitialized()) {
            SingletonUtils.initialize(null);
        }
    }

    public static void initLogger(LaunchConfig launchConfig) {
        MobyletLogger logger;
        block13: {
            String loggerClassName = "";
            if (launchConfig != null && (loggerClassName = launchConfig.getInitParameter("mobylet.logger.class")) == null) {
                loggerClassName = "";
            }
            logger = null;
            if (StringUtils.isEmpty(loggerClassName)) {
                logger = new LoggerImpl();
            } else {
                try {
                    Class<?> clazz = Class.forName(loggerClassName);
                    Class<MobyletLogger> loggerClass = clazz.asSubclass(MobyletLogger.class);
                    logger = loggerClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    logger = new LoggerImpl();
                    if (logger.isLoggable()) {
                        logger.log("[mobylet] \u6307\u5b9a\u3055\u308c\u305fLogger\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f = " + loggerClassName);
                    }
                }
                catch (ClassCastException e) {
                    logger = new LoggerImpl();
                    if (logger.isLoggable()) {
                        logger.log("[mobylet] \u6307\u5b9a\u3055\u308c\u305fLogger\u30af\u30e9\u30b9\u304cMobyletLogger\u306e\u5b9f\u88c5\u3067\u306f\u3042\u308a\u307e\u305b\u3093 = " + loggerClassName);
                    }
                }
                catch (InstantiationException e) {
                    logger = new LoggerImpl();
                    if (logger.isLoggable()) {
                        logger.log("[mobylet] \u6307\u5b9a\u3055\u308c\u305fLogger\u30af\u30e9\u30b9\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f  = " + loggerClassName);
                    }
                }
                catch (IllegalAccessException e) {
                    logger = new LoggerImpl();
                    if (!logger.isLoggable()) break block13;
                    logger.log("[mobylet] \u6307\u5b9a\u3055\u308c\u305fLogger\u30af\u30e9\u30b9\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f  = " + loggerClassName);
                }
            }
        }
        if (logger != null) {
            SingletonUtils.put(logger);
        } else {
            SingletonUtils.put(new LoggerImpl());
        }
    }

    public static void initInitializer(LaunchConfig launchConfig) {
        String configDir = "";
        if (launchConfig != null && (configDir = launchConfig.getInitParameter("mobylet.config.dir")) == null) {
            configDir = "";
        }
        MobyletConfigXmlReader configXml = new MobyletConfigXmlReader(configDir);
        MobyletConfig config = configXml.getConfig();
        for (MobyletInitializer initializer : config.getInitializers()) {
            initializer.initialize();
            SingletonUtils.put(initializer);
        }
    }

    public static void initDefaultCharset(LaunchConfig launchConfig) {
        Charset defCharset;
        String defCharsetName = null;
        if (launchConfig != null && (defCharsetName = launchConfig.getInitParameter("encoding")) != null && (defCharset = Charset.forName(defCharsetName)) != null) {
            SingletonUtils.put(defCharset);
        }
        if (SingletonUtils.get(Charset.class) == null) {
            SingletonUtils.put(Charset.forName("windows-31j"));
        }
    }
}

