/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype.registered;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.seasar.dbflute.util.DfTypeUtil;

public class BigDecimalType
extends TnAbstractValueType {
    public BigDecimalType() {
        super(3);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return resultSet.getBigDecimal(index);
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getBigDecimal(columnName);
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return cs.getBigDecimal(index);
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return cs.getBigDecimal(parameterName);
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setBigDecimal(index, DfTypeUtil.toBigDecimal(value));
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setBigDecimal(parameterName, DfTypeUtil.toBigDecimal(value));
        }
    }

    public String toText(Object value) {
        if (value == null) {
            return DfTypeUtil.nullText();
        }
        BigDecimal var = DfTypeUtil.toBigDecimal(value);
        return DfTypeUtil.toText(var);
    }
}

