/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.s2dao.beans.TnBeanDesc;
import org.seasar.dbflute.s2dao.beans.TnPropertyDesc;
import org.seasar.dbflute.s2dao.beans.exception.TnPropertyNotFoundRuntimeException;
import org.seasar.dbflute.s2dao.beans.factory.TnBeanDescFactory;
import org.seasar.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.seasar.dbflute.s2dao.identity.TnIdentifierGeneratorFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnModifiedPropertySupport;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyTypeFactory;
import org.seasar.dbflute.s2dao.metadata.impl.TnDtoMetaDataImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnBeanMetaDataImpl
extends TnDtoMetaDataImpl
implements TnBeanMetaData {
    private String tableName;
    private Map<String, TnPropertyType> columnNamePropertyTypeMap = StringKeyMap.createAsCaseInsensitiveConcurrent();
    private List<TnRelationPropertyType> relationPropertyTypes = new ArrayList<TnRelationPropertyType>();
    private TnPropertyType[] primaryKeys;
    private List<TnIdentifierGenerator> identifierGenerators = new ArrayList<TnIdentifierGenerator>();
    private Map<String, TnIdentifierGenerator> identifierGeneratorsByPropertyName = new HashMap<String, TnIdentifierGenerator>();
    private String versionNoPropertyName;
    private String timestampPropertyName;
    private TnModifiedPropertySupport modifiedPropertySupport;
    private TnRelationPropertyTypeFactory relationPropertyTypeFactory;

    @Override
    public void initialize() {
        TnBeanDesc beanDesc = TnBeanDescFactory.getBeanDesc(this.getBeanClass());
        this.setupTableName(beanDesc);
        this.setupProperty();
        this.setupPrimaryKey();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public TnPropertyType getVersionNoPropertyType() throws TnPropertyNotFoundRuntimeException {
        return this.getPropertyType(this.getVersionNoPropertyName());
    }

    @Override
    public TnPropertyType getTimestampPropertyType() throws TnPropertyNotFoundRuntimeException {
        return this.getPropertyType(this.getTimestampPropertyName());
    }

    @Override
    public String getVersionNoPropertyName() {
        return this.versionNoPropertyName;
    }

    public void setVersionNoPropertyName(String versionNoPropertyName) {
        this.versionNoPropertyName = versionNoPropertyName;
    }

    @Override
    public String getTimestampPropertyName() {
        return this.timestampPropertyName;
    }

    public void setTimestampPropertyName(String timestampPropertyName) {
        this.timestampPropertyName = timestampPropertyName;
    }

    @Override
    public TnPropertyType getPropertyTypeByColumnName(String columnName) {
        TnPropertyType propertyType = this.columnNamePropertyTypeMap.get(columnName);
        if (propertyType == null) {
            String msg = "The column was not found in the table: table=" + this.tableName + " column=" + columnName;
            throw new IllegalStateException(msg);
        }
        return propertyType;
    }

    @Override
    public TnPropertyType getPropertyTypeByAliasName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return this.getPropertyTypeByColumnName(alias);
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            String msg = "The alias was not found in the table: table=" + this.tableName + " alias=" + alias;
            throw new IllegalStateException(msg);
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            String msg = "The alias was not found in the table: table=" + this.tableName + " alias=" + alias;
            throw new IllegalStateException(msg, t);
        }
        TnRelationPropertyType rpt = this.getRelationPropertyType(relno);
        if (!rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName)) {
            String msg = "The alias was not found in the table: table=" + this.tableName + " alias=" + alias;
            throw new IllegalStateException(msg);
        }
        return rpt.getBeanMetaData().getPropertyTypeByColumnName(columnName);
    }

    @Override
    public boolean hasPropertyTypeByColumnName(String columnName) {
        return this.columnNamePropertyTypeMap.get(columnName) != null;
    }

    @Override
    public boolean hasPropertyTypeByAliasName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return true;
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            return false;
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            return false;
        }
        if (relno >= this.getRelationPropertyTypeSize()) {
            return false;
        }
        TnRelationPropertyType rpt = this.getRelationPropertyType(relno);
        return rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName);
    }

    @Override
    public boolean hasVersionNoPropertyType() {
        return this.hasPropertyType(this.getVersionNoPropertyName());
    }

    @Override
    public boolean hasTimestampPropertyType() {
        return this.hasPropertyType(this.getTimestampPropertyName());
    }

    @Override
    public String convertFullColumnName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return this.tableName + "." + alias;
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            String msg = "The alias was not found in the table: table=" + this.tableName + " alias=" + alias;
            throw new IllegalStateException(msg);
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            String msg = "The alias was not found in the table: table=" + this.tableName + " alias=" + alias;
            throw new IllegalStateException(msg, t);
        }
        TnRelationPropertyType rpt = this.getRelationPropertyType(relno);
        if (!rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName)) {
            String msg = "The alias was not found in the table: table=" + this.tableName + " alias=" + alias;
            throw new IllegalStateException(msg);
        }
        return rpt.getPropertyName() + "." + columnName;
    }

    @Override
    public int getRelationPropertyTypeSize() {
        return this.relationPropertyTypes.size();
    }

    @Override
    public TnRelationPropertyType getRelationPropertyType(int index) {
        return this.relationPropertyTypes.get(index);
    }

    @Override
    public TnRelationPropertyType getRelationPropertyType(String propertyName) throws TnPropertyNotFoundRuntimeException {
        for (int i = 0; i < this.getRelationPropertyTypeSize(); ++i) {
            TnRelationPropertyType rpt = this.relationPropertyTypes.get(i);
            if (rpt == null || !rpt.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            return rpt;
        }
        throw new TnPropertyNotFoundRuntimeException(this.getBeanClass(), propertyName);
    }

    protected void setupTableName(TnBeanDesc beanDesc) {
        String ta = this.beanAnnotationReader.getTableAnnotation();
        this.tableName = ta != null ? ta : "df:Unknown";
    }

    protected void setupProperty() {
        TnPropertyType[] propertyTypes = this.propertyTypeFactory.createBeanPropertyTypes();
        for (int i = 0; i < propertyTypes.length; ++i) {
            TnPropertyType pt = propertyTypes[i];
            this.addPropertyType(pt);
            this.columnNamePropertyTypeMap.put(pt.getColumnName(), pt);
        }
        TnRelationPropertyType[] relationPropertyTypes = this.relationPropertyTypeFactory.createRelationPropertyTypes();
        for (int i = 0; i < relationPropertyTypes.length; ++i) {
            TnRelationPropertyType rpt = relationPropertyTypes[i];
            this.addRelationPropertyType(rpt);
        }
    }

    protected void setupPrimaryKey() {
        ArrayList<TnPropertyType> keys = new ArrayList<TnPropertyType>();
        Set<String> keySet = this.propertyTypeMap.keySet();
        for (String key : keySet) {
            TnPropertyType pt = (TnPropertyType)this.propertyTypeMap.get(key);
            if (!pt.isPrimaryKey()) continue;
            keys.add(pt);
            this.setupIdentifierGenerator(pt);
        }
        this.primaryKeys = keys.toArray(new TnPropertyType[keys.size()]);
    }

    protected void setupIdentifierGenerator(TnPropertyType propertyType) {
        TnPropertyDesc pd = propertyType.getPropertyDesc();
        String propertyName = propertyType.getPropertyName();
        String idType = this.beanAnnotationReader.getId(pd);
        TnIdentifierGenerator generator = TnIdentifierGeneratorFactory.createIdentifierGenerator(propertyType, idType);
        this.identifierGenerators.add(generator);
        this.identifierGeneratorsByPropertyName.put(propertyName, generator);
    }

    protected void addRelationPropertyType(TnRelationPropertyType rpt) {
        for (int i = this.relationPropertyTypes.size(); i <= rpt.getRelationNo(); ++i) {
            this.relationPropertyTypes.add(null);
        }
        this.relationPropertyTypes.set(rpt.getRelationNo(), rpt);
    }

    @Override
    public int getPrimaryKeySize() {
        return this.primaryKeys.length;
    }

    @Override
    public String getPrimaryKey(int index) {
        return this.primaryKeys[index].getColumnName();
    }

    @Override
    public int getIdentifierGeneratorSize() {
        return this.identifierGenerators.size();
    }

    @Override
    public TnIdentifierGenerator getIdentifierGenerator(int index) {
        return this.identifierGenerators.get(index);
    }

    @Override
    public TnIdentifierGenerator getIdentifierGenerator(String propertyName) {
        return this.identifierGeneratorsByPropertyName.get(propertyName);
    }

    public TnModifiedPropertySupport getModifiedPropertySupport() {
        return this.modifiedPropertySupport;
    }

    public void setModifiedPropertySupport(TnModifiedPropertySupport propertyModifiedSupport) {
        this.modifiedPropertySupport = propertyModifiedSupport;
    }

    @Override
    public Set<String> getModifiedPropertyNames(Object bean) {
        return this.getModifiedPropertySupport().getModifiedPropertyNames(bean);
    }

    public void setRelationPropertyTypeFactory(TnRelationPropertyTypeFactory relationPropertyTypeFactory) {
        this.relationPropertyTypeFactory = relationPropertyTypeFactory;
    }
}

