/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.cms.CMSUtils;

public class CMSCompressedDataStreamGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";
    private int _bufferSize;

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public OutputStream open(OutputStream outputStream, String string) throws IOException {
        return this.open(outputStream, CMSObjectIdentifiers.data.getId(), string);
    }

    public OutputStream open(OutputStream outputStream, String string, String string2) throws IOException {
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject((DEREncodable)CMSObjectIdentifiers.compressedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject((DEREncodable)new DERInteger(0));
        DERSequenceGenerator dERSequenceGenerator = new DERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        dERSequenceGenerator.addObject((DEREncodable)new DERObjectIdentifier(ZLIB));
        dERSequenceGenerator.close();
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject((DEREncodable)new DERObjectIdentifier(string));
        OutputStream outputStream2 = CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, true, this._bufferSize);
        return new CmsCompressedOutputStream(new DeflaterOutputStream(outputStream2), bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
    }

    private class CmsCompressedOutputStream
    extends OutputStream {
        private DeflaterOutputStream _out;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _cGen;
        private BERSequenceGenerator _eiGen;

        CmsCompressedOutputStream(DeflaterOutputStream deflaterOutputStream, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this._out = deflaterOutputStream;
            this._sGen = bERSequenceGenerator;
            this._cGen = bERSequenceGenerator2;
            this._eiGen = bERSequenceGenerator3;
        }

        @Override
        public void write(int n) throws IOException {
            this._out.write(n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        @Override
        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            this._cGen.close();
            this._sGen.close();
        }
    }
}

