/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.httpsession;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.extension.httpsession.S2HttpServletRequestWrapper;
import org.seasar.extension.httpsession.S2HttpServletResponseWrapper;
import org.seasar.extension.httpsession.S2HttpSession;
import org.seasar.extension.httpsession.SessionIdUtil;
import org.seasar.extension.httpsession.SessionState;
import org.seasar.extension.httpsession.SessionStateManager;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class SessionFilter
implements Filter {
    private SessionStateManager sessionStateManager;

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SessionStateManager ssm = this.getSessionStateManager();
        S2HttpServletRequestWrapper requestWrapper = new S2HttpServletRequestWrapper((HttpServletRequest)request, ssm);
        S2HttpServletResponseWrapper responseWrapper = new S2HttpServletResponseWrapper((HttpServletResponse)response, requestWrapper, this.sessionStateManager);
        SessionIdUtil.writeCookie((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper, requestWrapper.getSessionId());
        try {
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        }
        finally {
            SessionState sessionState;
            S2HttpSession session = requestWrapper.getS2HttpSession();
            if (session != null && (sessionState = session.getSessionState()) != null) {
                ssm.updateState(session.getId(), sessionState);
            }
        }
    }

    protected SessionStateManager getSessionStateManager() {
        if (this.sessionStateManager == null) {
            S2Container container = SingletonS2ContainerFactory.getContainer();
            this.sessionStateManager = (SessionStateManager)container.getComponent((Object)SessionStateManager.class);
        }
        return this.sessionStateManager;
    }
}

