/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.seasar.robot.dbflute.exception.AccessContextNoValueException;
import org.seasar.robot.dbflute.exception.AccessContextNotFoundException;
import org.seasar.robot.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessContext {
    private static final ThreadLocal<AccessContext> _threadLocal = new ThreadLocal();
    protected String accessUser;
    protected String accessProcess;
    protected String accessModule;
    protected Date accessDate;
    protected AccessDateProvider accessDateProvider;
    protected Timestamp accessTimestamp;
    protected AccessTimestampProvider accessTimestampProvider;
    protected Map<String, Object> accessValueMap;

    public static AccessContext getAccessContextOnThread() {
        return _threadLocal.get();
    }

    public static void setAccessContextOnThread(AccessContext accessContext) {
        if (accessContext == null) {
            String msg = "The argument[accessContext] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        _threadLocal.set(accessContext);
    }

    public static boolean isExistAccessContextOnThread() {
        return _threadLocal.get() != null;
    }

    public static void clearAccessContextOnThread() {
        _threadLocal.set(null);
    }

    public static String getAccessUserOnThread() {
        AccessContext userContextOnThread;
        String accessUser;
        if (AccessContext.isExistAccessContextOnThread() && (accessUser = (userContextOnThread = AccessContext.getAccessContextOnThread()).getAccessUser()) != null) {
            return accessUser;
        }
        String methodName = "getAccessUserOnThread()";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException(methodName, "AccessUser", "user");
        } else {
            AccessContext.throwAccessContextNotFoundException(methodName);
        }
        return null;
    }

    public static String getAccessProcessOnThread() {
        AccessContext userContextOnThread;
        String accessProcess;
        if (AccessContext.isExistAccessContextOnThread() && (accessProcess = (userContextOnThread = AccessContext.getAccessContextOnThread()).getAccessProcess()) != null) {
            return accessProcess;
        }
        String methodName = "getAccessProcessOnThread()";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException(methodName, "AccessProcess", "process");
        } else {
            AccessContext.throwAccessContextNotFoundException(methodName);
        }
        return null;
    }

    public static String getAccessModuleOnThread() {
        AccessContext userContextOnThread;
        String accessModule;
        if (AccessContext.isExistAccessContextOnThread() && (accessModule = (userContextOnThread = AccessContext.getAccessContextOnThread()).getAccessModule()) != null) {
            return accessModule;
        }
        String methodName = "getAccessModuleOnThread()";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException(methodName, "AccessModule", "module");
        } else {
            AccessContext.throwAccessContextNotFoundException(methodName);
        }
        return null;
    }

    public static Date getAccessDateOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext userContextOnThread = AccessContext.getAccessContextOnThread();
            Date accessDate = userContextOnThread.getAccessDate();
            if (accessDate != null) {
                return accessDate;
            }
            if (userContextOnThread.getAccessDateProvider() != null) {
                return userContextOnThread.getAccessDateProvider().getAccessDate();
            }
        }
        return new Date();
    }

    public static Timestamp getAccessTimestampOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext userContextOnThread = AccessContext.getAccessContextOnThread();
            Timestamp accessTimestamp = userContextOnThread.getAccessTimestamp();
            if (accessTimestamp != null) {
                return accessTimestamp;
            }
            if (userContextOnThread.getAccessTimestampProvider() != null) {
                return userContextOnThread.getAccessTimestampProvider().getAccessTimestamp();
            }
        }
        return new Timestamp(System.currentTimeMillis());
    }

    public static Object getAccessValueOnThread(String key) {
        AccessContext userContextOnThread;
        Map<String, Object> accessValueMap;
        if (AccessContext.isExistAccessContextOnThread() && (accessValueMap = (userContextOnThread = AccessContext.getAccessContextOnThread()).getAccessValueMap()) != null) {
            return accessValueMap.get(key);
        }
        String methodName = "getAccessValueOnThread(\"" + key + "\")";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException(methodName, "AccessValue", "value");
        } else {
            AccessContext.throwAccessContextNotFoundException(methodName);
        }
        return null;
    }

    protected static void throwAccessContextNotFoundException(String methodName) {
        String msg = "Look! Read the message below." + AccessContext.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + AccessContext.ln();
        msg = msg + "The access context was Not Found on thread!" + AccessContext.ln();
        msg = msg + "{When you used AccessContext." + methodName + "}" + AccessContext.ln();
        msg = msg + AccessContext.ln();
        msg = msg + "[Advice]" + AccessContext.ln();
        msg = msg + "Please set up the access context before DB access(using common column auto set-up)." + AccessContext.ln();
        msg = msg + "You should set up it at your application's interceptor or filter." + AccessContext.ln();
        msg = msg + "  For example:" + AccessContext.ln();
        msg = msg + "    try {" + AccessContext.ln();
        msg = msg + "        AccessContext context = new AccessContext();" + AccessContext.ln();
        msg = msg + "        context.setAccessTimestamp(accessTimestamp);" + AccessContext.ln();
        msg = msg + "        context.setAccessUser(accessUser);" + AccessContext.ln();
        msg = msg + "        context.setAccessProcess(accessProcess);" + AccessContext.ln();
        msg = msg + "        AccessContext.setAccessContextOnThread(context);" + AccessContext.ln();
        msg = msg + "        return invocation.proceed();" + AccessContext.ln();
        msg = msg + "    } finally {" + AccessContext.ln();
        msg = msg + "        AccessContext.clearAccessContextOnThread();" + AccessContext.ln();
        msg = msg + "    }" + AccessContext.ln();
        msg = msg + "* * * * * * * * * */";
        throw new AccessContextNotFoundException(msg);
    }

    protected static void throwAccessContextNoValueException(String methodName, String capPropName, String aliasName) {
        String msg = "Look! Read the message below." + AccessContext.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + AccessContext.ln();
        msg = msg + "Failed to get the access " + aliasName + " in access context on thread!" + AccessContext.ln();
        msg = msg + "{When you used AccessContext." + methodName + "}" + AccessContext.ln();
        msg = msg + AccessContext.ln();
        msg = msg + "[Advice]" + AccessContext.ln();
        msg = msg + "Please set up the value before DB access(using common column auto set-up)." + AccessContext.ln();
        msg = msg + "You should set up it at your application's interceptor or filter." + AccessContext.ln();
        msg = msg + "  For example:" + AccessContext.ln();
        msg = msg + "    AccessContext context = new AccessContext();" + AccessContext.ln();
        msg = msg + "    context.set" + capPropName + "(...);" + AccessContext.ln();
        msg = msg + "    AccessContext.setAccessContextOnThread(context);" + AccessContext.ln();
        msg = msg + "* * * * * * * * * */";
        throw new AccessContextNoValueException(msg);
    }

    protected static String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public String toString() {
        return "{" + this.accessUser + ", " + this.accessProcess + ", " + this.accessModule + ", " + this.accessDate + ", " + this.accessDateProvider + ", " + this.accessTimestamp + ", " + this.accessTimestampProvider + ", " + this.accessValueMap + "}";
    }

    public String getAccessUser() {
        return this.accessUser;
    }

    public void setAccessUser(String accessUser) {
        this.accessUser = accessUser;
    }

    public String getAccessProcess() {
        return this.accessProcess;
    }

    public void setAccessProcess(String accessProcess) {
        this.accessProcess = accessProcess;
    }

    public String getAccessModule() {
        return this.accessModule;
    }

    public void setAccessModule(String accessModule) {
        this.accessModule = accessModule;
    }

    public Date getAccessDate() {
        return this.accessDate;
    }

    public void setAccessDate(Date accessDate) {
        this.accessDate = accessDate;
    }

    public AccessDateProvider getAccessDateProvider() {
        return this.accessDateProvider;
    }

    public void setAccessDateProvider(AccessDateProvider accessDateProvider) {
        this.accessDateProvider = accessDateProvider;
    }

    public Timestamp getAccessTimestamp() {
        return this.accessTimestamp;
    }

    public void setAccessTimestamp(Timestamp accessTimestamp) {
        this.accessTimestamp = accessTimestamp;
    }

    public AccessTimestampProvider getAccessTimestampProvider() {
        return this.accessTimestampProvider;
    }

    public void setAccessTimestampProvider(AccessTimestampProvider accessTimestampProvider) {
        this.accessTimestampProvider = accessTimestampProvider;
    }

    public Map<String, Object> getAccessValueMap() {
        return this.accessValueMap;
    }

    public void registerAccessValue(String key, Object value) {
        if (this.accessValueMap == null) {
            this.accessValueMap = new HashMap<String, Object>();
        }
        this.accessValueMap.put(key, value);
    }

    public static interface AccessTimestampProvider {
        public Timestamp getAccessTimestamp();
    }

    public static interface AccessDateProvider {
        public Date getAccessDate();
    }
}

