/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.servlet.FileItemContentStream;
import org.apache.solr.servlet.SolrRequestParser;
import org.apache.solr.servlet.SolrRequestParsers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultipartRequestParser
implements SolrRequestParser {
    private long uploadLimitKB;

    public MultipartRequestParser(long limit) {
        this.uploadLimitKB = limit;
    }

    @Override
    public SolrParams parseParamsAndFillStreams(HttpServletRequest req, ArrayList<ContentStream> streams) throws Exception {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not multipart content! " + req.getContentType());
        }
        MultiMapSolrParams params = SolrRequestParsers.parseQueryString(req.getQueryString());
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(this.uploadLimitKB * 1024L);
        List items = upload.parseRequest(req);
        for (FileItem item : items) {
            if (item.isFormField()) {
                MultiMapSolrParams.addParam((String)item.getFieldName(), (String)item.getString(), (Map)params.getMap());
                continue;
            }
            if (item.getSize() <= 0L) continue;
            streams.add((ContentStream)new FileItemContentStream(item));
        }
        return params;
    }
}

