/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class LinearFloatFunction
extends ValueSource {
    protected final ValueSource source;
    protected final float slope;
    protected final float intercept;

    public LinearFloatFunction(ValueSource source, float slope, float intercept) {
        this.source = source;
        this.slope = slope;
        this.intercept = intercept;
    }

    public String description() {
        return this.slope + "*float(" + this.source.description() + ")+" + this.intercept;
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        final DocValues vals = this.source.getValues(reader);
        return new DocValues(){

            public float floatVal(int doc) {
                return vals.floatVal(doc) * LinearFloatFunction.this.slope + LinearFloatFunction.this.intercept;
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                return LinearFloatFunction.this.slope + "*float(" + vals.toString(doc) + ")+" + LinearFloatFunction.this.intercept;
            }
        };
    }

    public int hashCode() {
        int h = Float.floatToIntBits(this.slope);
        h = h >>> 2 | h << 30;
        h += Float.floatToIntBits(this.intercept);
        h ^= h << 14 | h >>> 19;
        return h + this.source.hashCode();
    }

    public boolean equals(Object o) {
        if (LinearFloatFunction.class != o.getClass()) {
            return false;
        }
        LinearFloatFunction other = (LinearFloatFunction)o;
        return this.slope == other.slope && this.intercept == other.intercept && this.source.equals(other.source);
    }
}

