/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;

public class IntFieldSource
extends FieldCacheSource {
    FieldCache.IntParser parser;

    public IntFieldSource(String field) {
        this(field, null);
    }

    public IntFieldSource(String field, FieldCache.IntParser parser) {
        super(field);
        this.parser = parser;
    }

    public String description() {
        return "int(" + this.field + ')';
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        final int[] arr = this.parser == null ? this.cache.getInts(reader, this.field) : this.cache.getInts(reader, this.field, this.parser);
        return new DocValues(){

            public float floatVal(int doc) {
                return arr[doc];
            }

            public int intVal(int doc) {
                return arr[doc];
            }

            public long longVal(int doc) {
                return arr[doc];
            }

            public double doubleVal(int doc) {
                return arr[doc];
            }

            public String strVal(int doc) {
                return Float.toString(arr[doc]);
            }

            public String toString(int doc) {
                return IntFieldSource.this.description() + '=' + this.intVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        if (o.getClass() != IntFieldSource.class) {
            return false;
        }
        IntFieldSource other = (IntFieldSource)o;
        return super.equals(other) && this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass();
    }

    public int hashCode() {
        int h = this.parser == null ? Integer.class.hashCode() : this.parser.getClass().hashCode();
        return h += super.hashCode();
    }
}

