/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.ExtendedFieldCache;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardFieldSortedHitQueue;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.OldLuceneQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.util.SolrPluginUtils;

public class QueryComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "query";

    public void prepare(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        String fl = params.get("fl");
        int fieldFlags = 0;
        if (fl != null) {
            fieldFlags |= SolrPluginUtils.setReturnFields(fl, rsp);
        }
        rb.setFieldFlags(fieldFlags);
        String defType = params.get("defType");
        String string = defType = defType == null ? OldLuceneQParserPlugin.NAME : defType;
        if (rb.getQueryString() == null) {
            rb.setQueryString(params.get("q"));
        }
        try {
            QParser parser = QParser.getParser(rb.getQueryString(), defType, req);
            rb.setQuery(parser.getQuery());
            rb.setSortSpec(parser.getSort(true));
            rb.setQparser(parser);
            String[] fqs = req.getParams().getParams("fq");
            if (fqs != null && fqs.length != 0) {
                List<Query> filters = rb.getFilters();
                if (filters == null) {
                    filters = new ArrayList<Query>();
                    rb.setFilters(filters);
                }
                for (String fq : fqs) {
                    if (fq == null || fq.trim().length() == 0) continue;
                    QParser fqp = QParser.getParser(fq, null, req);
                    filters.add(fqp.getQuery());
                }
            }
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        String shards = params.get("shards");
        if (shards != null) {
            List lst = StrUtils.splitSmart((String)shards, (String)",", (boolean)true);
            rb.shards = lst.toArray(new String[lst.size()]);
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrIndexSearcher searcher = req.getSearcher();
        SolrParams params = req.getParams();
        long timeAllowed = params.getInt("timeAllowed", -1);
        String ids = params.get("ids");
        if (ids != null) {
            SchemaField idField = req.getSchema().getUniqueKeyField();
            List idArr = StrUtils.splitSmart((String)ids, (String)",", (boolean)true);
            int[] luceneIds = new int[idArr.size()];
            int docs = 0;
            for (int i = 0; i < idArr.size(); ++i) {
                int id = req.getSearcher().getFirstMatch(new Term(idField.getName(), idField.getType().toInternal((String)idArr.get(i))));
                if (id < 0) continue;
                luceneIds[docs++] = id;
            }
            DocListAndSet res = new DocListAndSet();
            res.docList = new DocSlice(0, docs, luceneIds, null, docs, 0.0f);
            if (rb.isNeedDocSet()) {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(rb.getQuery());
                List<Query> filters = rb.getFilters();
                if (filters != null) {
                    queries.addAll(filters);
                }
                res.docSet = searcher.getDocSet(queries);
            }
            rb.setResults(res);
            rsp.add("response", rb.getResults().docList);
            return;
        }
        SolrIndexSearcher.QueryCommand cmd = rb.getQueryCommand();
        cmd.setTimeAllowed(timeAllowed);
        SolrIndexSearcher.QueryResult result = new SolrIndexSearcher.QueryResult();
        searcher.search(result, cmd);
        rb.setResult(result);
        rsp.add("response", rb.getResults().docList);
        rsp.getToLog().add("hits", (Object)rb.getResults().docList.matches());
        boolean fsv = req.getParams().getBool("fsv", false);
        if (fsv) {
            SortField[] sortFieldArray;
            Sort sort = rb.getSortSpec().getSort();
            if (sort == null) {
                SortField[] sortFieldArray2 = new SortField[1];
                sortFieldArray = sortFieldArray2;
                sortFieldArray2[0] = SortField.FIELD_SCORE;
            } else {
                sortFieldArray = sort.getSort();
            }
            SortField[] sortFields = sortFieldArray;
            ScoreDoc sd = new ScoreDoc(0, 1.0f);
            NamedList sortVals = new NamedList();
            StringFieldable field = new StringFieldable();
            for (SortField sortField : sortFields) {
                int type = sortField.getType();
                if (type == 0 || type == 1) continue;
                ScoreDocComparator comparator = null;
                IndexReader reader = searcher.getReader();
                String fieldname = sortField.getField();
                FieldType ft = fieldname == null ? null : req.getSchema().getFieldTypeNoEx(fieldname);
                switch (type) {
                    case 4: {
                        comparator = QueryComponent.comparatorInt(reader, fieldname);
                        break;
                    }
                    case 5: {
                        comparator = QueryComponent.comparatorFloat(reader, fieldname);
                        break;
                    }
                    case 6: {
                        comparator = QueryComponent.comparatorLong(reader, fieldname);
                        break;
                    }
                    case 7: {
                        comparator = QueryComponent.comparatorDouble(reader, fieldname);
                        break;
                    }
                    case 3: {
                        if (sortField.getLocale() != null) {
                            comparator = QueryComponent.comparatorStringLocale(reader, fieldname, sortField.getLocale());
                            break;
                        }
                        comparator = QueryComponent.comparatorString(reader, fieldname);
                        break;
                    }
                    case 9: {
                        comparator = sortField.getFactory().newComparator(reader, fieldname);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unknown field type: " + type);
                    }
                }
                DocList docList = rb.getResults().docList;
                ArrayList<Comparable> vals = new ArrayList<Comparable>(docList.size());
                DocIterator it = rb.getResults().docList.iterator();
                while (it.hasNext()) {
                    sd.doc = it.nextDoc();
                    Object val = comparator.sortValue(sd);
                    if (val instanceof String) {
                        field.val = (String)val;
                        val = ft.toObject(field);
                    }
                    vals.add((Comparable)val);
                }
                sortVals.add(fieldname, vals);
            }
            rsp.add("sort_values", sortVals);
        }
        if (!req.getParams().getBool("isShard", false) && rb.getResults().docList != null && rb.getResults().docList.size() <= 50) {
            SolrPluginUtils.optimizePreFetchDocs(rb.getResults().docList, rb.getQuery(), req, rsp);
        }
    }

    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (rb.stage < ResponseBuilder.STAGE_PARSE_QUERY) {
            return ResponseBuilder.STAGE_PARSE_QUERY;
        }
        if (rb.stage == ResponseBuilder.STAGE_PARSE_QUERY) {
            this.createDistributedIdf(rb);
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            this.createMainQuery(rb);
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        if (rb.stage < ResponseBuilder.STAGE_GET_FIELDS) {
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            this.createRetrieveDocs(rb);
            return ResponseBuilder.STAGE_DONE;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if ((sreq.purpose & 4) != 0) {
            this.mergeIds(rb, sreq);
            return;
        }
        if ((sreq.purpose & 0x40) != 0) {
            this.returnFields(rb, sreq);
            return;
        }
    }

    public void finishStage(ResponseBuilder rb) {
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            Iterator iter = rb._responseDocs.iterator();
            while (iter.hasNext()) {
                if (iter.next() != null) continue;
                iter.remove();
                rb._responseDocs.setNumFound(rb._responseDocs.getNumFound() - 1L);
            }
            rb.rsp.add("response", rb._responseDocs);
        }
    }

    private void createDistributedIdf(ResponseBuilder rb) {
    }

    private void createMainQuery(ResponseBuilder rb) {
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 4;
        sreq.params = new ModifiableSolrParams(rb.req.getParams());
        sreq.params.remove("shards");
        sreq.params.set("start", new String[]{"0"});
        sreq.params.set("rows", rb.getSortSpec().getOffset() + rb.getSortSpec().getCount());
        sreq.params.set("fsv", new String[]{"true"});
        if ((rb.getFieldFlags() & 1) != 0 || rb.getSortSpec().includesScore()) {
            sreq.params.set("fl", new String[]{rb.req.getSchema().getUniqueKeyField().getName() + ",score"});
        } else {
            sreq.params.set("fl", new String[]{rb.req.getSchema().getUniqueKeyField().getName()});
        }
        rb.addRequest(this, sreq);
    }

    private void mergeIds(ResponseBuilder rb, ShardRequest sreq) {
        SortSpec ss = rb.getSortSpec();
        Sort sort = ss.getSort();
        SortField[] sortFields = null;
        sortFields = sort != null ? sort.getSort() : new SortField[]{SortField.FIELD_SCORE};
        SchemaField uniqueKeyField = rb.req.getSchema().getUniqueKeyField();
        HashMap<Object, String> uniqueDoc = new HashMap<Object, String>();
        ShardFieldSortedHitQueue queue = new ShardFieldSortedHitQueue(sortFields, ss.getOffset() + ss.getCount());
        long numFound = 0L;
        Float maxScore = null;
        for (ShardResponse srsp : sreq.responses) {
            SolrDocumentList docs = (SolrDocumentList)srsp.getSolrResponse().getResponse().get("response");
            if (docs.getMaxScore() != null) {
                maxScore = Float.valueOf(maxScore == null ? docs.getMaxScore().floatValue() : Math.max(maxScore.floatValue(), docs.getMaxScore().floatValue()));
            }
            numFound += docs.getNumFound();
            NamedList sortFieldValues = (NamedList)srsp.getSolrResponse().getResponse().get("sort_values");
            for (int i = 0; i < docs.size(); ++i) {
                SolrDocument doc = (SolrDocument)docs.get(i);
                Object id = doc.getFieldValue(uniqueKeyField.getName());
                String prevShard = uniqueDoc.put(id, srsp.getShard());
                if (prevShard != null) {
                    --numFound;
                    continue;
                }
                ShardDoc shardDoc = new ShardDoc();
                shardDoc.id = id;
                shardDoc.shard = srsp.getShard();
                shardDoc.orderInShard = i;
                Object scoreObj = doc.getFieldValue("score");
                if (scoreObj != null) {
                    shardDoc.score = scoreObj instanceof String ? Float.valueOf(Float.parseFloat((String)scoreObj)) : (Float)scoreObj;
                }
                shardDoc.sortFieldValues = sortFieldValues;
                queue.insert(shardDoc);
            }
        }
        int resultSize = queue.size() - ss.getOffset();
        resultSize = Math.max(0, resultSize);
        HashMap<Object, ShardDoc> resultIds = new HashMap<Object, ShardDoc>();
        int i = resultSize - 1;
        while (i >= 0) {
            ShardDoc shardDoc = (ShardDoc)queue.pop();
            shardDoc.positionInResponse = i--;
            resultIds.put(shardDoc.id.toString(), shardDoc);
        }
        SolrDocumentList responseDocs = new SolrDocumentList();
        if (maxScore != null) {
            responseDocs.setMaxScore(maxScore);
        }
        responseDocs.setNumFound(numFound);
        responseDocs.setStart((long)ss.getOffset());
        for (int i2 = 0; i2 < resultSize; ++i2) {
            responseDocs.add(null);
        }
        rb.resultIds = resultIds;
        rb._responseDocs = responseDocs;
    }

    private void createRetrieveDocs(ResponseBuilder rb) {
        HashMap shardMap = new HashMap();
        for (ShardDoc sdoc : rb.resultIds.values()) {
            Collection shardDocs = (ArrayList<ShardDoc>)shardMap.get(sdoc.shard);
            if (shardDocs == null) {
                shardDocs = new ArrayList<ShardDoc>();
                shardMap.put(sdoc.shard, shardDocs);
            }
            shardDocs.add(sdoc);
        }
        SchemaField uniqueField = rb.req.getSchema().getUniqueKeyField();
        for (Collection shardDocs : shardMap.values()) {
            ShardRequest sreq = new ShardRequest();
            sreq.purpose = 64;
            sreq.shards = new String[]{((ShardDoc)shardDocs.iterator().next()).shard};
            sreq.params = new ModifiableSolrParams();
            sreq.params.add(rb.req.getParams());
            sreq.params.remove("sort");
            sreq.params.remove("fsv");
            String fl = sreq.params.get("fl");
            if (fl != null) {
                sreq.params.set("fl", new String[]{fl + ',' + uniqueField.getName()});
            }
            ArrayList<String> ids = new ArrayList<String>(shardDocs.size());
            for (ShardDoc shardDoc : shardDocs) {
                ids.add(shardDoc.id.toString());
            }
            sreq.params.add("ids", new String[]{StrUtils.join(ids, (char)',')});
            rb.addRequest(this, sreq);
        }
    }

    private void returnFields(ResponseBuilder rb, ShardRequest sreq) {
        if ((sreq.purpose & 0x40) != 0) {
            boolean returnScores;
            boolean bl = returnScores = (rb.getFieldFlags() & 1) != 0;
            assert (sreq.responses.size() == 1);
            ShardResponse srsp = sreq.responses.get(0);
            SolrDocumentList docs = (SolrDocumentList)srsp.getSolrResponse().getResponse().get("response");
            String keyFieldName = rb.req.getSchema().getUniqueKeyField().getName();
            for (SolrDocument doc : docs) {
                Object id = doc.getFieldValue(keyFieldName);
                ShardDoc sdoc = rb.resultIds.get(id.toString());
                if (returnScores && sdoc.score != null) {
                    doc.setField("score", (Object)sdoc.score);
                }
                rb._responseDocs.set(sdoc.positionInResponse, (Object)doc);
            }
        }
    }

    static ScoreDocComparator comparatorInt(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final int[] fieldOrder = FieldCache.DEFAULT.getInts(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                int fi = fieldOrder[i.doc];
                int fj = fieldOrder[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return new Integer(fieldOrder[i.doc]);
            }

            public int sortType() {
                return 4;
            }
        };
    }

    static ScoreDocComparator comparatorLong(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final long[] fieldOrder = ExtendedFieldCache.EXT_DEFAULT.getLongs(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                long li = fieldOrder[i.doc];
                long lj = fieldOrder[j.doc];
                if (li < lj) {
                    return -1;
                }
                if (li > lj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return new Long(fieldOrder[i.doc]);
            }

            public int sortType() {
                return 6;
            }
        };
    }

    static ScoreDocComparator comparatorFloat(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final float[] fieldOrder = FieldCache.DEFAULT.getFloats(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                float fi = fieldOrder[i.doc];
                float fj = fieldOrder[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return new Float(fieldOrder[i.doc]);
            }

            public int sortType() {
                return 5;
            }
        };
    }

    static ScoreDocComparator comparatorDouble(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final double[] fieldOrder = ExtendedFieldCache.EXT_DEFAULT.getDoubles(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                double di = fieldOrder[i.doc];
                double dj = fieldOrder[j.doc];
                if (di < dj) {
                    return -1;
                }
                if (di > dj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return new Double(fieldOrder[i.doc]);
            }

            public int sortType() {
                return 7;
            }
        };
    }

    static ScoreDocComparator comparatorString(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final FieldCache.StringIndex index = FieldCache.DEFAULT.getStringIndex(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                int fi = index.order[i.doc];
                int fj = index.order[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return index.lookup[index.order[i.doc]];
            }

            public int sortType() {
                return 3;
            }
        };
    }

    static ScoreDocComparator comparatorStringLocale(IndexReader reader, String fieldname, Locale locale) throws IOException {
        final Collator collator = Collator.getInstance(locale);
        String field = fieldname.intern();
        final String[] index = FieldCache.DEFAULT.getStrings(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                String is = index[i.doc];
                String js = index[j.doc];
                if (is == js) {
                    return 0;
                }
                if (is == null) {
                    return -1;
                }
                if (js == null) {
                    return 1;
                }
                return collator.compare(is, js);
            }

            public Comparable sortValue(ScoreDoc i) {
                return index[i.doc];
            }

            public int sortType() {
                return 3;
            }
        };
    }

    public String getDescription() {
        return COMPONENT_NAME;
    }

    public String getVersion() {
        return "$Revision: 694446 $";
    }

    public String getSourceId() {
        return "$Id: QueryComponent.java 694446 2008-09-11 20:03:34Z yonik $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/src/java/org/apache/solr/handler/component/QueryComponent.java $";
    }

    public URL[] getDocs() {
        return null;
    }

    static class StringFieldable
    implements Fieldable {
        public String val;

        StringFieldable() {
        }

        public void setBoost(float boost) {
        }

        public float getBoost() {
            return 0.0f;
        }

        public String name() {
            return null;
        }

        public String stringValue() {
            return this.val;
        }

        public Reader readerValue() {
            return null;
        }

        public byte[] binaryValue() {
            return new byte[0];
        }

        public TokenStream tokenStreamValue() {
            return null;
        }

        public boolean isStored() {
            return true;
        }

        public boolean isIndexed() {
            return true;
        }

        public boolean isTokenized() {
            return true;
        }

        public boolean isCompressed() {
            return false;
        }

        public boolean isTermVectorStored() {
            return false;
        }

        public boolean isStoreOffsetWithTermVector() {
            return false;
        }

        public boolean isStorePositionWithTermVector() {
            return false;
        }

        public boolean isBinary() {
            return false;
        }

        public boolean getOmitNorms() {
            return false;
        }

        public void setOmitNorms(boolean omitNorms) {
        }

        public void setOmitTf(boolean omitTf) {
        }

        public boolean getOmitTf() {
            return false;
        }

        public boolean isLazy() {
            return false;
        }

        public int getBinaryOffset() {
            return 0;
        }

        public int getBinaryLength() {
            return 0;
        }

        public byte[] getBinaryValue() {
            return new byte[0];
        }

        public byte[] getBinaryValue(byte[] result) {
            return new byte[0];
        }
    }
}

