/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.KeepWordFilter;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeepWordFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private Set<String> words;
    private boolean ignoreCase;

    @Override
    public void inform(ResourceLoader loader) {
        String wordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        if (wordFiles != null) {
            if (this.words == null) {
                this.words = new HashSet<String>();
            }
            try {
                File keepWordsFile = new File(wordFiles);
                if (keepWordsFile.exists()) {
                    List wlist = loader.getLines(wordFiles);
                    this.words = StopFilter.makeStopSet((String[])wlist.toArray(new String[0]), (boolean)this.ignoreCase);
                } else {
                    List files = StrUtils.splitFileNames((String)wordFiles);
                    for (String file : files) {
                        List wlist = loader.getLines(file.trim());
                        this.words.addAll(StopFilter.makeStopSet((String[])wlist.toArray(new String[0]), (boolean)this.ignoreCase));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setWords(Set<String> words) {
        this.words = words;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public KeepWordFilter create(TokenStream input) {
        return new KeepWordFilter(input, this.words, this.ignoreCase);
    }
}

