/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeepWordFilter
extends TokenFilter {
    final CharArraySet words;

    public KeepWordFilter(TokenStream in, Set<String> words, boolean ignoreCase) {
        super(in);
        this.words = new CharArraySet(words, ignoreCase);
    }

    public final Token next(Token in) throws IOException {
        Token token = this.input.next(in);
        while (token != null) {
            if (this.words.contains(token.termBuffer(), 0, token.termLength())) {
                return token;
            }
            token = this.input.next();
        }
        return null;
    }
}

