/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.Parameterized;

public class ParameterizedTestTest {
    private static String fLog;

    @Test
    public void count() {
        Result result = JUnitCore.runClasses(FibonacciTest.class);
        Assert.assertEquals(7, result.getRunCount());
        Assert.assertEquals(6, result.getFailureCount());
    }

    @Test
    public void failuresNamedCorrectly() {
        Result result = JUnitCore.runClasses(FibonacciTest.class);
        Assert.assertEquals(String.format("test[1](%s)", FibonacciTest.class.getName()), result.getFailures().get(0).getTestHeader());
    }

    @Test
    public void countBeforeRun() throws Exception {
        Runner runner = Request.aClass(FibonacciTest.class).getRunner();
        Assert.assertEquals(7, runner.testCount());
    }

    @Test
    public void plansNamedCorrectly() throws Exception {
        Runner runner = Request.aClass(FibonacciTest.class).getRunner();
        Description description = runner.getDescription();
        Assert.assertEquals("[0]", description.getChildren().get(0).getDisplayName());
    }

    @Test
    public void beforeAndAfterClassAreRun() {
        fLog = "";
        JUnitCore.runClasses(BeforeAndAfter.class);
        Assert.assertEquals("before after ", fLog);
    }

    @Test
    public void validateClassCatchesNoParameters() {
        Result result = JUnitCore.runClasses(EmptyTest.class);
        Assert.assertEquals(1, result.getFailureCount());
    }

    @Test
    public void failuresAddedForBadTestMethod() throws Exception {
        Result result = JUnitCore.runClasses(IncorrectTest.class);
        Assert.assertEquals(1, result.getFailureCount());
    }

    @Test
    public void meaningfulFailureWhenParametersNotPublic() throws Exception {
        Result result = JUnitCore.runClasses(ProtectedParametersTest.class);
        String expected = String.format("No public static parameters method on class %s", ProtectedParametersTest.class.getName());
        Assert.assertEquals(expected, result.getFailures().get(0).getMessage());
    }

    @Test
    public void meaningfulFailureWhenParameterListsAreNotArrays() {
        Result result = JUnitCore.runClasses(WrongElementType.class);
        String expected = String.format("%s.data() must return a Collection of arrays.", WrongElementType.class.getName());
        Assert.assertEquals(expected, result.getFailures().get(0).getMessage());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RunWith(value=Parameterized.class)
    public static class WrongElementType {
        @Parameterized.Parameters
        public static Collection<String> data() {
            return Arrays.asList("a", "b", "c");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RunWith(value=Parameterized.class)
    public static class ProtectedParametersTest {
        @Parameterized.Parameters
        protected static Collection<Object[]> data() {
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RunWith(value=Parameterized.class)
    public static class IncorrectTest {
        @Test
        public int test() {
            return 0;
        }

        @Parameterized.Parameters
        public static Collection<Object[]> data() {
            return Parameterized.eachOne(1);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class EmptyTest {
        @BeforeClass
        public static void before() {
            fLog = fLog + "before ";
        }

        @AfterClass
        public static void after() {
            fLog = fLog + "after ";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RunWith(value=Parameterized.class)
    public static class BeforeAndAfter {
        @BeforeClass
        public static void before() {
            fLog = fLog + "before ";
        }

        @AfterClass
        public static void after() {
            fLog = fLog + "after ";
        }

        @Parameterized.Parameters
        public static Collection<Object[]> data() {
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RunWith(value=Parameterized.class)
    public static class FibonacciTest {
        private int fInput;
        private int fExpected;

        @Parameterized.Parameters
        public static Collection<Object[]> data() {
            return Arrays.asList({0, 0}, {1, 1}, {2, 1}, {3, 2}, {4, 3}, {5, 5}, {6, 8});
        }

        public FibonacciTest(int input, int expected) {
            this.fInput = input;
            this.fExpected = expected;
        }

        @Test
        public void test() {
            Assert.assertEquals(this.fExpected, this.fib(this.fInput));
        }

        private int fib(int x) {
            return 0;
        }
    }
}

