/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class ExpectedTest {
    @Test
    public void expected() {
        JUnitCore core = new JUnitCore();
        Result result = core.run(Expected.class);
        Assert.assertTrue(result.wasSuccessful());
    }

    @Test
    public void unexpected() {
        Result result = JUnitCore.runClasses(Unexpected.class);
        Failure failure = result.getFailures().get(0);
        String message = failure.getMessage();
        Assert.assertTrue(message.contains("expected<java.lang.Exception> but was<java.lang.Error>"));
        Assert.assertEquals(Error.class, failure.getException().getCause().getClass());
    }

    @Test
    public void noneThrown() {
        JUnitCore core = new JUnitCore();
        Result result = core.run(NoneThrown.class);
        Assert.assertFalse(result.wasSuccessful());
        String message = result.getFailures().get(0).getMessage();
        Assert.assertTrue(message.contains("Expected exception: java.lang.Exception"));
    }

    @Test
    public void expectsSuperclass() {
        Assert.assertTrue(new JUnitCore().run(ExpectSuperclass.class).wasSuccessful());
    }

    public static class ExpectSuperclass {
        @Test(expected=RuntimeException.class)
        public void throwsSubclass() {
            throw new ClassCastException();
        }
    }

    public static class NoneThrown {
        @Test(expected=Exception.class)
        public void nothing() {
        }
    }

    public static class Unexpected {
        @Test(expected=Exception.class)
        public void expected() throws Exception {
            throw new Error();
        }
    }

    public static class Expected {
        @Test(expected=Exception.class)
        public void expected() throws Exception {
            throw new Exception();
        }
    }
}

