/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.Enclosed;

public class EnclosedTest {
    @Test
    public void enclosedRunnerPlansEnclosedClasses() throws Exception {
        Runner runner = Request.aClass(Enclosing.class).getRunner();
        Assert.assertEquals(5, runner.testCount());
    }

    @Test
    public void enclosedRunnerRunsEnclosedClasses() throws Exception {
        Result result = JUnitCore.runClasses(Enclosing.class);
        Assert.assertEquals(5, result.getRunCount());
    }

    @Test
    public void enclosedRunnerIsNamedForEnclosingClass() throws Exception {
        Assert.assertEquals(Enclosing.class.getName(), Request.aClass(Enclosing.class).getRunner().getDescription().getDisplayName());
    }

    @RunWith(value=Enclosed.class)
    public static class Enclosing {

        public static class B {
            @Test
            public void a() {
            }

            @Test
            public void b() {
            }

            @Test
            public void c() {
            }
        }

        public static class A {
            @Test
            public void a() {
            }

            @Test
            public void b() {
            }
        }
    }
}

