/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class ShingleFilter
extends TokenFilter {
    private LinkedList shingleBuf = new LinkedList();
    private LinkedList outputBuf = new LinkedList();
    private LinkedList tokenBuf = new LinkedList();
    private StringBuffer[] shingles;
    private String tokenType = "shingle";
    public static final char[] FILLER_TOKEN = new char[]{'_'};
    public static final int DEFAULT_MAX_SHINGLE_SIZE = 2;
    public static final String TOKEN_SEPARATOR = " ";
    private boolean outputUnigrams = true;
    private int maxShingleSize;

    public ShingleFilter(TokenStream input, int maxShingleSize) {
        super(input);
        this.setMaxShingleSize(maxShingleSize);
    }

    public ShingleFilter(TokenStream input) {
        this(input, 2);
    }

    public ShingleFilter(TokenStream input, String tokenType) {
        this(input, 2);
        this.setTokenType(tokenType);
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setOutputUnigrams(boolean outputUnigrams) {
        this.outputUnigrams = outputUnigrams;
    }

    public void setMaxShingleSize(int maxShingleSize) {
        if (maxShingleSize < 2) {
            throw new IllegalArgumentException("Max shingle size must be >= 2");
        }
        this.shingles = new StringBuffer[maxShingleSize];
        for (int i = 0; i < this.shingles.length; ++i) {
            this.shingles[i] = new StringBuffer();
        }
        this.maxShingleSize = maxShingleSize;
    }

    private void clearShingles() {
        for (int i = 0; i < this.shingles.length; ++i) {
            this.shingles[i].setLength(0);
        }
    }

    public Token next(Token reusableToken) throws IOException {
        assert (reusableToken != null);
        if (this.outputBuf.isEmpty()) {
            this.fillOutputBuf(reusableToken);
        }
        Token nextToken = null;
        if (!this.outputBuf.isEmpty()) {
            nextToken = (Token)this.outputBuf.remove(0);
        }
        return nextToken;
    }

    private Token getNextToken(Token reusableToken) throws IOException {
        if (this.tokenBuf.isEmpty()) {
            Token nextToken = this.input.next(reusableToken);
            if (nextToken != null) {
                for (int i = 1; i < nextToken.getPositionIncrement(); ++i) {
                    Token fillerToken = (Token)nextToken.clone();
                    fillerToken.setEndOffset(fillerToken.startOffset());
                    fillerToken.setTermBuffer(FILLER_TOKEN, 0, FILLER_TOKEN.length);
                    this.tokenBuf.add(fillerToken);
                }
                this.tokenBuf.add(nextToken.clone());
                return this.getNextToken(nextToken);
            }
            return null;
        }
        return (Token)this.tokenBuf.remove(0);
    }

    private void fillOutputBuf(Token token) throws IOException {
        int i;
        boolean addedToken = false;
        while ((token = this.getNextToken(token)) != null) {
            this.shingleBuf.add(token.clone());
            if (this.shingleBuf.size() > this.maxShingleSize) {
                this.shingleBuf.remove(0);
            }
            addedToken = true;
            if (this.shingleBuf.size() < this.maxShingleSize) continue;
        }
        if (!addedToken) {
            if (this.shingleBuf.isEmpty()) {
                return;
            }
            this.shingleBuf.remove(0);
        }
        this.clearShingles();
        int[] endOffsets = new int[this.shingleBuf.size()];
        for (i = 0; i < endOffsets.length; ++i) {
            endOffsets[i] = 0;
        }
        i = 0;
        Token shingle2 = null;
        for (Token shingle2 : this.shingleBuf) {
            for (int j = i; j < this.shingles.length; ++j) {
                if (this.shingles[j].length() != 0) {
                    this.shingles[j].append(TOKEN_SEPARATOR);
                }
                this.shingles[j].append(shingle2.termBuffer(), 0, shingle2.termLength());
            }
            endOffsets[i] = shingle2.endOffset();
            ++i;
        }
        if (!this.shingleBuf.isEmpty() && this.outputUnigrams) {
            Token unigram = (Token)this.shingleBuf.getFirst();
            unigram.setPositionIncrement(1);
            this.outputBuf.add(unigram);
        }
        if (!this.shingleBuf.isEmpty()) {
            Token firstShingle = (Token)this.shingleBuf.get(0);
            shingle2 = (Token)firstShingle.clone();
            shingle2.setType(this.tokenType);
        }
        for (int j = 1; j < this.shingleBuf.size(); ++j) {
            shingle2.setEndOffset(endOffsets[j]);
            StringBuffer buf = this.shingles[j];
            int termLength = buf.length();
            char[] termBuffer = shingle2.termBuffer();
            if (termBuffer.length < termLength) {
                termBuffer = shingle2.resizeTermBuffer(termLength);
            }
            buf.getChars(0, termLength, termBuffer, 0);
            shingle2.setTermLength(termLength);
            if (!this.outputUnigrams && j == 1) {
                shingle2.setPositionIncrement(1);
            } else {
                shingle2.setPositionIncrement(0);
            }
            this.outputBuf.add(shingle2.clone());
        }
    }
}

