/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.beans.exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnMethodNotFoundRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Class<?> targetClass;
    private String methodName;
    private Class<?>[] methodArgClasses;

    public TnMethodNotFoundRuntimeException(Class<?> targetClass, String methodName, Object[] methodArgs) {
        super("The method was not found: class=" + targetClass.getName() + " method=" + methodName + " args=" + TnMethodNotFoundRuntimeException.getSignature(methodArgs));
        this.targetClass = targetClass;
        this.methodName = methodName;
        if (methodArgs != null) {
            this.methodArgClasses = new Class[methodArgs.length];
            for (int i = 0; i < methodArgs.length; ++i) {
                if (methodArgs[i] == null) continue;
                this.methodArgClasses[i] = methodArgs[i].getClass();
            }
        }
    }

    public TnMethodNotFoundRuntimeException(Class<?> targetClass, String methodName, Class<?>[] methodArgClasses) {
        super("The method was not found: class=" + targetClass.getName() + " method=" + methodName + " args=" + TnMethodNotFoundRuntimeException.getSignature(methodArgClasses));
        this.targetClass = targetClass;
        this.methodName = methodName;
        this.methodArgClasses = methodArgClasses;
    }

    private static String getSignature(Object[] methodArgs) {
        StringBuffer buf = new StringBuffer(100);
        if (methodArgs != null) {
            for (int i = 0; i < methodArgs.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if (methodArgs[i] != null) {
                    buf.append(methodArgs[i].getClass().getName());
                    continue;
                }
                buf.append("null");
            }
        }
        return buf.toString();
    }

    private static String getSignature(Class<?>[] paramTypes) {
        StringBuffer buf = new StringBuffer(100);
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if (paramTypes[i] != null) {
                    buf.append(paramTypes[i].getName());
                    continue;
                }
                buf.append("null");
            }
        }
        return buf.toString();
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getMethodArgClasses() {
        return this.methodArgClasses;
    }
}

