/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringKeyMap<VALUE>
implements Map<String, VALUE> {
    protected final Map<String, VALUE> _internalMap;
    protected boolean _removeUnderscore;

    protected StringKeyMap(boolean removeUnderscore, boolean order, boolean concurrent) {
        if (order && concurrent) {
            String msg = "The 'order' and 'concurrent' should not be both true at the same time!";
            throw new IllegalStateException(msg);
        }
        this._removeUnderscore = removeUnderscore;
        this._internalMap = concurrent ? StringKeyMap.newConcurrentHashMap() : (order ? StringKeyMap.newLinkedHashMap() : StringKeyMap.newHashMap());
    }

    public static <VALUE> StringKeyMap<VALUE> createAsCaseInsensitive() {
        return new StringKeyMap<VALUE>(false, false, false);
    }

    public static <VALUE> StringKeyMap<VALUE> createAsCaseInsensitiveConcurrent() {
        return new StringKeyMap<VALUE>(false, false, true);
    }

    public static <VALUE> StringKeyMap<VALUE> createAsCaseInsensitiveOrder() {
        return new StringKeyMap<VALUE>(false, true, false);
    }

    public static <VALUE> StringKeyMap<VALUE> createAsFlexible() {
        return new StringKeyMap<VALUE>(true, false, false);
    }

    public static <VALUE> StringKeyMap<VALUE> createAsFlexibleConcurrent() {
        return new StringKeyMap<VALUE>(true, false, true);
    }

    public static <VALUE> StringKeyMap<VALUE> createAsFlexibleOrder() {
        return new StringKeyMap<VALUE>(true, true, false);
    }

    @Override
    public VALUE get(Object key) {
        String stringKey = this.convertStringKey(key);
        if (stringKey != null) {
            return this._internalMap.get(stringKey);
        }
        return null;
    }

    @Override
    public VALUE put(String key, VALUE value) {
        String stringKey = this.convertStringKey(key);
        if (stringKey != null) {
            return this._internalMap.put(stringKey, value);
        }
        return null;
    }

    @Override
    public VALUE remove(Object key) {
        String stringKey = this.convertStringKey(key);
        if (stringKey != null) {
            return this._internalMap.remove(stringKey);
        }
        return null;
    }

    @Override
    public final void putAll(Map<? extends String, ? extends VALUE> map) {
        Set<Map.Entry<String, VALUE>> entrySet = map.entrySet();
        Iterator<Map.Entry<String, VALUE>> i$ = entrySet.iterator();
        while (i$.hasNext()) {
            Map.Entry<String, VALUE> entryObj;
            Map.Entry<String, VALUE> entry = entryObj = i$.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public void clear() {
        this._internalMap.clear();
    }

    @Override
    public int size() {
        return this._internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._internalMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this._internalMap.keySet();
    }

    @Override
    public Collection<VALUE> values() {
        return this._internalMap.values();
    }

    @Override
    public boolean containsValue(Object obj) {
        return this._internalMap.containsValue(obj);
    }

    @Override
    public Set<Map.Entry<String, VALUE>> entrySet() {
        return this._internalMap.entrySet();
    }

    protected String convertStringKey(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        return this.toLowerCase(this.removeUnderscore((String)key));
    }

    protected String removeUnderscore(String value) {
        if (this._removeUnderscore) {
            return StringKeyMap.replace(value, "_", "");
        }
        return value;
    }

    protected String toLowerCase(String value) {
        return value.toLowerCase();
    }

    protected static String replace(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(100);
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(fromText, pos2)) == 0) {
                sb.append(toText);
                pos2 = fromText.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(text.substring(pos2, pos));
            sb.append(toText);
            pos2 = pos + fromText.length();
        }
        sb.append(text.substring(pos2));
        return sb.toString();
    }

    protected static <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    protected static <KEY, VALUE> HashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected static <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    @Override
    public boolean equals(Object obj) {
        return ((Object)this._internalMap).equals(obj);
    }

    @Override
    public int hashCode() {
        return ((Object)this._internalMap).hashCode();
    }

    public String toString() {
        return this._internalMap.toString();
    }
}

