/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.util.List;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagingInvoker<ENTITY> {
    protected String _tableDbName;

    public PagingInvoker(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    public PagingResultBean<ENTITY> invokePaging(PagingHandler<ENTITY> handler) {
        int allRecordCount;
        List<ENTITY> selectedList;
        this.assertObjectNotNull("handler", handler);
        PagingBean pagingBean = handler.getPagingBean();
        this.assertObjectNotNull("handler.getPagingBean()", pagingBean);
        if (!pagingBean.isFetchScopeEffective()) {
            String msg = "The paging bean is not effective about fetch-scope!";
            msg = msg + " When you select page, you should set up fetch-scope of";
            msg = msg + " paging bean(Should invoke fetchFirst() and fetchPage()!).";
            msg = msg + " The paging bean is: " + pagingBean;
            throw new IllegalStateException(msg);
        }
        ResultBeanBuilder<ENTITY> builder = this.createResultBeanBuilder();
        if (pagingBean.isCountLater()) {
            selectedList = handler.paging();
            allRecordCount = this.isCurrentLastPage(selectedList, pagingBean) ? this.deriveAllRecordCountFromLastPageValues(selectedList, pagingBean) : handler.count();
        } else {
            allRecordCount = handler.count();
            selectedList = allRecordCount == 0 ? builder.buildEmptyListResultBean(pagingBean) : handler.paging();
        }
        PagingResultBean<ENTITY> rb = builder.buildPagingResultBean(pagingBean, allRecordCount, selectedList);
        if (pagingBean.canPagingReSelect() && this.isNecessaryToReadPageAgain(rb)) {
            pagingBean.fetchPage(rb.getAllPageCount());
            int reAllRecordCount = handler.count();
            List<ENTITY> reSelectedList = handler.paging();
            return builder.buildPagingResultBean(pagingBean, reAllRecordCount, reSelectedList);
        }
        return rb;
    }

    protected ResultBeanBuilder<ENTITY> createResultBeanBuilder() {
        return new ResultBeanBuilder(this._tableDbName);
    }

    protected boolean isCurrentLastPage(List<ENTITY> selectedList, PagingBean pagingBean) {
        return selectedList.size() <= pagingBean.getFetchSize() - 1;
    }

    protected int deriveAllRecordCountFromLastPageValues(List<ENTITY> selectedList, PagingBean pagingBean) {
        int baseSize = (pagingBean.getFetchPageNumber() - 1) * pagingBean.getFetchSize();
        return baseSize + selectedList.size();
    }

    protected boolean isNecessaryToReadPageAgain(PagingResultBean<ENTITY> rb) {
        return rb.getAllRecordCount() > 0 && rb.getSelectedList().isEmpty();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }
}

