/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.filter.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.robot.filter.impl.AbstractUrlFilter;

public class UrlFilterImpl
extends AbstractUrlFilter {
    protected String urlPattern = "^(.*:/+)([^/]*)(.*)$";
    protected String includeFilteringPattern;
    protected String excludeFilteringPattern;

    public boolean match(String url) {
        Matcher matcher;
        boolean match;
        if (!this.includeList.isEmpty()) {
            match = false;
            for (Pattern pattern : this.includeList) {
                matcher = pattern.matcher(url);
                if (!matcher.matches()) continue;
                match = true;
            }
            if (!match) {
                return false;
            }
        }
        if (!this.excludeList.isEmpty()) {
            match = false;
            for (Pattern pattern : this.excludeList) {
                matcher = pattern.matcher(url);
                if (!matcher.matches()) continue;
                match = true;
            }
            if (match) {
                return false;
            }
        }
        return true;
    }

    public void processUrl(String url) {
        if (this.includeFilteringPattern != null) {
            this.addInclude(url.replaceAll(this.urlPattern, this.includeFilteringPattern));
        }
        if (this.excludeFilteringPattern != null) {
            this.addExclude(url.replaceAll(this.urlPattern, this.excludeFilteringPattern));
        }
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String getIncludeFilteringPattern() {
        return this.includeFilteringPattern;
    }

    public void setIncludeFilteringPattern(String includeFilteringPattern) {
        this.includeFilteringPattern = includeFilteringPattern;
    }

    public String getExcludeFilteringPattern() {
        return this.excludeFilteringPattern;
    }

    public void setExcludeFilteringPattern(String excludeFilteringPattern) {
        this.excludeFilteringPattern = excludeFilteringPattern;
    }
}

