/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import org.apache.lucene.analysis.Token;
import org.apache.lucene.search.highlight.SimpleFragmenter;

class GapFragmenter
extends SimpleFragmenter {
    public static final int INCREMENT_THRESHOLD = 50;
    protected int fragOffsetAccum = 0;

    public GapFragmenter() {
    }

    public GapFragmenter(int fragsize) {
        super(fragsize);
    }

    public void start(String originalText) {
        this.fragOffsetAccum = 0;
    }

    public boolean isNewFragment(Token token) {
        boolean isNewFrag;
        boolean bl = isNewFrag = token.endOffset() >= this.fragOffsetAccum + this.getFragmentSize() || token.getPositionIncrement() > 50;
        if (isNewFrag) {
            this.fragOffsetAccum += token.endOffset() - this.fragOffsetAccum;
        }
        return isNewFrag;
    }
}

