/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FindClasses {
    private JarFile[] jarFiles;
    private ClassLoader cl;

    public static void main(String[] args) throws ClassNotFoundException, IOException, NoSuchMethodException {
        FindClasses finder = new FindClasses(new File(args[1]));
        ClassLoader cl = finder.getClassLoader();
        Class<?> clazz = cl.loadClass(args[0]);
        if (args.length == 2) {
            System.out.println("Finding all extenders of " + clazz.getName());
            for (Class c : finder.findExtends(clazz)) {
                System.out.println(c.getName());
            }
        } else {
            String methName = args[2];
            System.out.println("Finding all extenders of " + clazz.getName() + " with method: " + methName);
            Class[] methArgs = new Class[args.length - 3];
            for (int i = 3; i < args.length; ++i) {
                methArgs[i - 3] = cl.loadClass(args[i]);
            }
            Map<Class, Class> map = finder.findMethodReturns(finder.findExtends(clazz), methName, methArgs);
            for (Class key : map.keySet()) {
                System.out.println(key.getName() + " => " + map.get(key).getName());
            }
        }
    }

    public FindClasses(File ... jars) throws IOException {
        this.jarFiles = new JarFile[jars.length];
        URL[] urls = new URL[jars.length];
        try {
            for (int i = 0; i < jars.length; ++i) {
                this.jarFiles[i] = new JarFile(jars[i]);
                urls[i] = jars[i].toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("WTF, how can JarFile.toURL() be malformed?", e);
        }
        this.cl = new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public Collection<Class> findExtends(Class<?> clazz) throws ClassNotFoundException {
        HashSet<Class> results = new HashSet<Class>();
        for (JarFile jarFile : this.jarFiles) {
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                int mods;
                Class<?> target;
                String n = e.nextElement().getName();
                if (!n.endsWith(".class")) continue;
                String cn = n.replace("/", ".").substring(0, n.length() - 6);
                try {
                    target = this.cl.loadClass(cn);
                }
                catch (NoClassDefFoundError e1) {
                    throw new ClassNotFoundException("Can't load: " + cn, e1);
                }
                if (!clazz.isAssignableFrom(target) || target.isAnonymousClass() || Modifier.isAbstract(mods = target.getModifiers()) || Modifier.isInterface(mods)) continue;
                results.add(target);
            }
        }
        return results;
    }

    public Map<Class, Class> findMethodReturns(Collection<Class> clazzes, String methodName, Class ... parameterTypes) throws NoSuchMethodException {
        HashMap<Class, Class> results = new HashMap<Class, Class>();
        for (Class clazz : clazzes) {
            try {
                Method m = clazz.getMethod(methodName, parameterTypes);
                results.put(clazz, m.getReturnType());
            }
            catch (NoSuchMethodException e) {}
        }
        return results;
    }
}

