/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public abstract class SimpleFloatFunction
extends ValueSource {
    protected final ValueSource source;

    public SimpleFloatFunction(ValueSource source) {
        this.source = source;
    }

    protected abstract String name();

    protected abstract float func(int var1, DocValues var2);

    public String description() {
        return this.name() + '(' + this.source.description() + ')';
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        final DocValues vals = this.source.getValues(reader);
        return new DocValues(){

            public float floatVal(int doc) {
                return SimpleFloatFunction.this.func(doc, vals);
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                return SimpleFloatFunction.this.name() + '(' + vals.toString(doc) + ')';
            }
        };
    }

    public int hashCode() {
        return this.source.hashCode() + this.name().hashCode();
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFloatFunction other = (SimpleFloatFunction)o;
        return this.name().equals(other.name()) && this.source.equals(other.source);
    }
}

