/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.solr.client.solrj.util.ClientUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetField
implements Serializable {
    private String _name = null;
    private List<Count> _values = null;
    private String _gap = null;
    private Date _end = null;

    public FacetField(String n) {
        this._name = n;
    }

    public FacetField(String name, String gap, Date end) {
        this._name = name;
        this._gap = gap;
        this._end = end;
    }

    public String getGap() {
        return this._gap;
    }

    public Date getEnd() {
        return this._end;
    }

    public void add(String name, long cnt) {
        if (this._values == null) {
            this._values = new ArrayList<Count>(30);
        }
        this._values.add(new Count(this, name, cnt));
    }

    public void insert(String name, long cnt) {
        if (this._values == null) {
            this._values = new ArrayList<Count>(30);
        }
        this._values.add(0, new Count(this, name, cnt));
    }

    public String getName() {
        return this._name;
    }

    public List<Count> getValues() {
        return this._values;
    }

    public int getValueCount() {
        return this._values == null ? 0 : this._values.size();
    }

    public FacetField getLimitingFields(long max) {
        FacetField ff = new FacetField(this._name);
        if (this._values != null) {
            ff._values = new ArrayList<Count>(this._values.size());
            for (Count c : this._values) {
                if (c._count >= max) continue;
                ff._values.add(c);
            }
        }
        return ff;
    }

    public String toString() {
        return this._name + ":" + this._values;
    }

    public static class Count
    implements Serializable {
        private String _name = null;
        private long _count = 0L;
        private FacetField _ff = null;

        public Count(FacetField ff, String n, long c) {
            this._name = n;
            this._count = c;
            this._ff = ff;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String n) {
            this._name = n;
        }

        public long getCount() {
            return this._count;
        }

        public void setCount(long c) {
            this._count = c;
        }

        public FacetField getFacetField() {
            return this._ff;
        }

        public String toString() {
            return this._name + " (" + this._count + ")";
        }

        public String getAsFilterQuery() {
            if (this._ff.getName().equals("facet_queries")) {
                return this._name;
            }
            return ClientUtils.escapeQueryChars(this._ff._name) + ":" + ClientUtils.escapeQueryChars(this._name);
        }
    }
}

