/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenizerFactory;
import org.apache.solr.common.SolrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternTokenizerFactory
extends BaseTokenizerFactory {
    public static final String PATTERN = "pattern";
    public static final String GROUP = "group";
    protected Map<String, String> args;
    protected Pattern pattern;
    protected int group;

    @Override
    public void init(Map<String, String> args) {
        this.args = args;
        String regex = args.get(PATTERN);
        if (regex == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "missing required argument: pattern");
        }
        int flags = 0;
        this.pattern = Pattern.compile(regex, flags);
        this.group = -1;
        String g = args.get(GROUP);
        if (g != null) {
            try {
                this.group = Integer.parseInt(g);
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "invalid group argument: " + g);
            }
        }
    }

    @Override
    public TokenStream create(Reader input) {
        try {
            String str = IOUtils.toString((Reader)input);
            Matcher matcher = this.pattern.matcher(str);
            List<Token> tokens = this.group < 0 ? PatternTokenizerFactory.split(matcher, str) : PatternTokenizerFactory.group(matcher, str, this.group);
            final Iterator<Token> iter = tokens.iterator();
            return new TokenStream(){

                public Token next() throws IOException {
                    if (iter.hasNext()) {
                        return (Token)iter.next();
                    }
                    return null;
                }
            };
        }
        catch (IOException ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ex);
        }
    }

    public static List<Token> split(Matcher matcher, String input) {
        String match;
        int index = 0;
        int lastNonEmptySize = Integer.MAX_VALUE;
        ArrayList<Token> matchList = new ArrayList<Token>();
        while (matcher.find()) {
            match = ((Object)input.subSequence(index, matcher.start())).toString();
            matchList.add(new Token(match, index, matcher.start()));
            index = matcher.end();
            if (match.length() <= 0) continue;
            lastNonEmptySize = matchList.size();
        }
        if (index == 0) {
            matchList.add(new Token(input, 0, input.length()));
        } else {
            match = ((Object)input.subSequence(index, input.length())).toString();
            matchList.add(new Token(match, index, input.length()));
            if (match.length() > 0) {
                lastNonEmptySize = matchList.size();
            }
        }
        if (lastNonEmptySize < matchList.size()) {
            return matchList.subList(0, lastNonEmptySize);
        }
        return matchList;
    }

    public static List<Token> group(Matcher matcher, String input, int group) {
        ArrayList<Token> matchList = new ArrayList<Token>();
        while (matcher.find()) {
            Token t = new Token(matcher.group(group), matcher.start(group), matcher.end(group));
            matchList.add(t);
        }
        return matchList;
    }
}

