/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.view.designer;

import java.util.ArrayList;
import java.util.List;
import org.mobylet.core.Carrier;
import org.mobylet.core.Mobylet;
import org.mobylet.core.MobyletFactory;
import org.mobylet.core.device.DeviceDisplay;
import org.mobylet.core.gps.GeoConverter;
import org.mobylet.core.gps.Gps;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.util.UrlUtils;

public class GoogleMapDesigner {
    public static final String URL = "http://maps.google.com/staticmap";
    public static final Integer DEFAULT_WIDTH = 240;
    public static final Integer DEFAULT_HEIGHT = 240;
    public static final Integer MAX_WIDTH = 640;
    public static final Integer MAX_HEIGHT = 640;
    protected String key;
    protected Gps center;
    protected Integer width;
    protected Integer height;
    protected Integer zoom = 15;
    protected Boolean sensor = false;
    protected List<Gps> markers;

    public static GoogleMapDesigner getDesigner(String key) {
        return new GoogleMapDesigner(key);
    }

    public GoogleMapDesigner(String key) {
        this.key = key;
        this.markers = new ArrayList<Gps>();
    }

    public String getSrc() {
        Mobylet m = MobyletFactory.getInstance();
        if (this.center == null || StringUtils.isEmpty(this.center.getStrLat()) || StringUtils.isEmpty(this.center.getStrLon())) {
            Gps gps = m.getGps();
            if (gps != null) {
                gps = SingletonUtils.get(GeoConverter.class).toWgs84(gps);
                this.setCenter(gps);
            } else {
                return "";
            }
        }
        if (this.markers == null || this.markers.size() == 0) {
            Gps marker = new Gps(this.center);
            this.addMarker(marker);
        }
        if (this.width == null && this.height == null) {
            DeviceDisplay dp = m.getDisplay();
            if (dp != null) {
                this.setWidth(dp.getWidth());
                this.setHeight(dp.getHeight());
            } else if (Carrier.OTHER == m.getCarrier()) {
                this.setWidth(MAX_WIDTH);
                this.setHeight(MAX_HEIGHT);
            } else {
                this.setWidth(DEFAULT_WIDTH);
                this.setHeight(DEFAULT_HEIGHT);
            }
        }
        String url = URL;
        if (m.getCarrier() != Carrier.OTHER) {
            url = UrlUtils.addParameter(url, "maptype", "mobile");
        }
        url = UrlUtils.addParameter(url, "key", this.getKey());
        url = UrlUtils.addParameter(url, "center", this.center.getLat() + "," + this.center.getLon(), false);
        url = UrlUtils.addParameter(url, "zoom", "" + this.getZoom());
        url = UrlUtils.addParameter(url, "size", "" + this.getWidth() + "x" + this.getHeight());
        url = UrlUtils.addParameter(url, "sensor", "" + this.getSensor());
        for (Gps marker : this.markers) {
            marker = SingletonUtils.get(GeoConverter.class).toWgs84(marker);
            url = UrlUtils.addParameter(url, "markers", marker.getLat() + "," + marker.getLon(), false);
        }
        return url;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Gps getCenter() {
        return this.center;
    }

    public void setCenter(Gps center) {
        this.center = center;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getZoom() {
        return this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    public Boolean getSensor() {
        return this.sensor;
    }

    public void setSensor(Boolean sensor) {
        this.sensor = sensor;
    }

    public List<Gps> getMarkers() {
        return this.markers;
    }

    public void setMarkers(List<Gps> markers) {
        this.markers = markers;
    }

    public void addMarker(Gps marker) {
        this.markers.add(marker);
    }
}

