/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.http;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.mobylet.core.Carrier;
import org.mobylet.core.emoji.Emoji;
import org.mobylet.core.emoji.EmojiPoolFamily;
import org.mobylet.core.selector.CharsetSelector;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class MobyletPrintWriter
extends PrintWriter {
    protected Carrier outCarrier;
    protected EmojiPoolFamily family;
    protected CharsetSelector charSelector;

    public MobyletPrintWriter(Writer out, Carrier outCarrier) {
        super(out);
        this.outCarrier = outCarrier;
        this.family = SingletonUtils.get(EmojiPoolFamily.class);
        this.charSelector = SingletonUtils.get(CharsetSelector.class);
    }

    @Override
    public void write(int c) {
        if (this.charSelector.isCharsetInstalled() && this.family != null) {
            char ch = (char)c;
            Emoji e = this.family.getEmoji(ch);
            if (e == null) {
                super.write(c);
            } else {
                Emoji related = e.getRelated(this.outCarrier);
                if (related == null) {
                    super.write(c);
                } else {
                    char[] codes = related.getCodes();
                    if (codes != null) {
                        for (char code : codes) {
                            super.write(code);
                        }
                    }
                }
            }
        } else {
            super.write(c);
        }
    }

    @Override
    public void write(char[] buf, int off, int len) {
        if (this.charSelector.isCharsetInstalled() && this.family != null) {
            CharArrayWriter caw = new CharArrayWriter(len);
            for (int i = off; i < off + len; ++i) {
                Emoji e = this.family.getEmoji(buf[i]);
                if (e == null) {
                    caw.append(buf[i]);
                    continue;
                }
                Emoji related = e.getRelated(this.outCarrier);
                if (related == null) {
                    caw.append(buf[i]);
                    continue;
                }
                char[] codes = related.getCodes();
                if (codes == null) continue;
                for (char code : codes) {
                    caw.append(code);
                }
            }
            char[] chars = caw.toCharArray();
            super.write(chars, 0, chars.length);
        } else {
            super.write(buf, off, len);
        }
    }

    @Override
    public void write(String s, int off, int len) {
        if (StringUtils.isNotEmpty(s)) {
            this.write(s.toCharArray(), off, len);
        }
    }
}

