/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataConfig;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.VariableResolverImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextImpl
extends Context {
    private DataConfig.Entity entity;
    private ContextImpl parent;
    private VariableResolverImpl resolver;
    private DataSource ds;
    private int currProcess;
    private Map<String, Object> requestParams;
    private DataImporter dataImporter;
    private Map<String, Object> entitySession;
    private Map<String, Object> globalSession;
    private Map<String, Object> docSession;

    public ContextImpl(DataConfig.Entity entity, VariableResolverImpl resolver, DataSource ds, int currProcess, Map<String, Object> requestParams, Map<String, Object> global, ContextImpl p, DataImporter di) {
        this.entity = entity;
        this.resolver = resolver;
        this.ds = ds;
        this.currProcess = currProcess;
        this.requestParams = requestParams;
        this.globalSession = global;
        this.parent = p;
        this.dataImporter = di;
    }

    @Override
    public String getEntityAttribute(String name) {
        return this.entity == null ? null : this.entity.allAttributes.get(name);
    }

    @Override
    public List<Map<String, String>> getAllEntityFields() {
        return this.entity == null ? Collections.EMPTY_LIST : this.entity.allFieldsList;
    }

    @Override
    public VariableResolver getVariableResolver() {
        return this.resolver;
    }

    @Override
    public DataSource getDataSource() {
        return this.ds;
    }

    @Override
    public DataSource getDataSource(String name) {
        return this.dataImporter.getDataSourceInstance(this.entity, name, this);
    }

    @Override
    public boolean isRootEntity() {
        return this.entity.isDocRoot;
    }

    @Override
    public int currentProcess() {
        return this.currProcess;
    }

    @Override
    public Map<String, Object> getRequestParameters() {
        return this.requestParams;
    }

    @Override
    public EntityProcessor getEntityProcessor() {
        return this.entity == null ? null : this.entity.processor;
    }

    @Override
    public void setSessionAttribute(String name, Object val, String scope) {
        Map<String, Object> docsession;
        if ("entity".equals(scope)) {
            if (this.entitySession == null) {
                this.entitySession = new HashMap<String, Object>();
            }
            this.entitySession.put(name, val);
        } else if ("global".equals(scope)) {
            if (this.globalSession != null) {
                this.globalSession.put(name, val);
            }
        } else if ("document".equals(scope) && (docsession = this.getDocSession()) != null) {
            docsession.put(name, val);
        }
    }

    @Override
    public Object getSessionAttribute(String name, String scope) {
        Map<String, Object> docsession;
        if ("entity".equals(scope)) {
            if (this.entitySession == null) {
                return null;
            }
            return this.entitySession.get(name);
        }
        if ("global".equals(scope)) {
            if (this.globalSession != null) {
                return this.globalSession.get(name);
            }
        } else if ("document".equals(scope) && (docsession = this.getDocSession()) != null) {
            return docsession.get(name);
        }
        return null;
    }

    @Override
    public Context getParentContext() {
        return this.parent;
    }

    public Map<String, Object> getDocSession() {
        ContextImpl c = this;
        while (true) {
            if (c.docSession != null) {
                return c.docSession;
            }
            if (c.parent == null) break;
            c = c.parent;
        }
        return null;
    }

    public void setDocSession(Map<String, Object> docSession) {
        this.docSession = docSession;
    }

    @Override
    public SolrCore getSolrCore() {
        return this.dataImporter == null ? null : this.dataImporter.getCore();
    }
}

