/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.opendocument;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.opendocument.NSNormalizerContentHandler;
import org.apache.tika.sax.ElementMappingContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenOfficeContentParser
implements Parser {
    public static final String TEXT_NS = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    public static final String TABLE_NS = "urn:oasis:names:tc:opendocument:xmlns:table:1.0";
    public static final String XLINK_NS = "http://www.w3.org/1999/xlink";
    protected static final char[] TAB = new char[]{'\t'};
    private static final HashMap<QName, ElementMappingContentHandler.TargetElement> MAPPINGS = new HashMap();

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, Map<String, Object> context) throws IOException, SAXException, TikaException {
        final XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        ElementMappingContentHandler dh = new ElementMappingContentHandler((ContentHandler)xhtml, MAPPINGS){
            private final BitSet textNodeStack;
            private int nodeDepth;
            private int completelyFiltered;
            private Stack<String> headingStack;
            {
                super(x0, x1);
                this.textNodeStack = new BitSet();
                this.nodeDepth = 0;
                this.completelyFiltered = 0;
                this.headingStack = new Stack();
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.completelyFiltered == 0 && this.nodeDepth > 0 && this.textNodeStack.get(this.nodeDepth - 1)) {
                    super.characters(ch, start, length);
                }
            }

            private boolean needsCompleteFiltering(String namespaceURI, String localName) {
                if (OpenOfficeContentParser.TEXT_NS.equals(namespaceURI)) {
                    return localName.endsWith("-template") || localName.endsWith("-style");
                }
                if (OpenOfficeContentParser.TABLE_NS.equals(namespaceURI)) {
                    return "covered-table-cell".equals(localName);
                }
                return false;
            }

            private String getXHTMLHeaderTagName(Attributes atts) {
                String depthStr = atts.getValue(OpenOfficeContentParser.TEXT_NS, "outline-level");
                if (depthStr == null) {
                    return "h1";
                }
                int depth = Integer.parseInt(depthStr);
                if (depth >= 6) {
                    return "h6";
                }
                if (depth <= 1) {
                    return "h1";
                }
                return "h" + depth;
            }

            public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                assert (this.nodeDepth >= 0);
                this.textNodeStack.set(this.nodeDepth++, OpenOfficeContentParser.TEXT_NS.equals(namespaceURI));
                assert (this.completelyFiltered >= 0);
                if (this.needsCompleteFiltering(namespaceURI, localName)) {
                    ++this.completelyFiltered;
                }
                if (this.completelyFiltered == 0) {
                    if (OpenOfficeContentParser.TEXT_NS.equals(namespaceURI) && "h".equals(localName)) {
                        xhtml.startElement(this.headingStack.push(this.getXHTMLHeaderTagName(atts)));
                    } else {
                        super.startElement(namespaceURI, localName, qName, atts);
                    }
                }
            }

            public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                if (this.completelyFiltered == 0) {
                    if (OpenOfficeContentParser.TEXT_NS.equals(namespaceURI) && "h".equals(localName)) {
                        xhtml.endElement(this.headingStack.pop());
                    } else {
                        super.endElement(namespaceURI, localName, qName);
                    }
                    if (OpenOfficeContentParser.TEXT_NS.equals(namespaceURI) && ("tab-stop".equals(localName) || "tab".equals(localName))) {
                        this.characters(TAB, 0, TAB.length);
                    }
                }
                if (this.needsCompleteFiltering(namespaceURI, localName)) {
                    --this.completelyFiltered;
                }
                assert (this.completelyFiltered >= 0);
                --this.nodeDepth;
                assert (this.nodeDepth >= 0);
            }

            public void startPrefixMapping(String prefix, String uri) {
            }

            public void endPrefixMapping(String prefix) {
            }
        };
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXParser parser = factory.newSAXParser();
            parser.parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler((ContentHandler)((Object)new NSNormalizerContentHandler((ContentHandler)dh))));
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("XML parser configuration error", (Throwable)e);
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        Map<String, Object> context = Collections.emptyMap();
        this.parse(stream, handler, metadata, context);
    }

    static {
        MAPPINGS.put(new QName(TEXT_NS, "p"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "p"));
        MAPPINGS.put(new QName(TEXT_NS, "line-break"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "br"));
        MAPPINGS.put(new QName(TEXT_NS, "list"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "ul"));
        MAPPINGS.put(new QName(TEXT_NS, "list-item"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "li"));
        MAPPINGS.put(new QName(TEXT_NS, "note"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(TEXT_NS, "span"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "span"));
        MAPPINGS.put(new QName(TEXT_NS, "a"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "a", Collections.singletonMap(new QName(XLINK_NS, "href"), new QName("href"))));
        MAPPINGS.put(new QName(TABLE_NS, "table"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "table"));
        MAPPINGS.put(new QName(TABLE_NS, "table-row"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "tr"));
        HashMap<QName, QName> tableCellAttsMapping = new HashMap<QName, QName>();
        tableCellAttsMapping.put(new QName(TABLE_NS, "number-columns-spanned"), new QName("colspan"));
        tableCellAttsMapping.put(new QName(TABLE_NS, "number-rows-spanned"), new QName("rowspan"));
        tableCellAttsMapping.put(new QName(TABLE_NS, "number-columns-repeated"), new QName("colspan"));
        MAPPINGS.put(new QName(TABLE_NS, "table-cell"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "td", tableCellAttsMapping));
    }
}

