/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.service.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.jdbc.CursorHandler;
import org.seasar.framework.beans.util.Beans;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.db.cbean.AccessResultCB;
import org.seasar.robot.db.cbean.AccessResultDataCB;
import org.seasar.robot.db.exbhv.AccessResultBhv;
import org.seasar.robot.db.exbhv.AccessResultDataBhv;
import org.seasar.robot.db.exbhv.cursor.AccessResultDiffCursor;
import org.seasar.robot.db.exbhv.cursor.AccessResultDiffCursorHandler;
import org.seasar.robot.db.exbhv.pmbean.AccessResultPmb;
import org.seasar.robot.db.exentity.AccessResult;
import org.seasar.robot.db.exentity.AccessResultData;
import org.seasar.robot.service.DataService;
import org.seasar.robot.util.AccessResultCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBDataServiceImpl
implements DataService {
    private static final Logger logger = LoggerFactory.getLogger(DBDataServiceImpl.class);
    @Resource
    protected AccessResultBhv accessResultBhv;
    @Resource
    protected AccessResultDataBhv accessResultDataBhv;

    public void store(org.seasar.robot.entity.AccessResult accessResult) {
        if (accessResult == null) {
            throw new RobotSystemException("AccessResult is null.");
        }
        this.accessResultBhv.insert((AccessResult)accessResult);
        org.seasar.robot.entity.AccessResultData accessResultData = accessResult.getAccessResultData();
        if (accessResultData == null) {
            accessResultData = new AccessResultData();
            accessResultData.setTransformerName("NONE");
        }
        accessResultData.setId(accessResult.getId());
        this.accessResultDataBhv.insert((AccessResultData)accessResultData);
    }

    public int getCount(String sessionId) {
        AccessResultCB cb = new AccessResultCB();
        cb.query().setSessionId_Equal(sessionId);
        return this.accessResultBhv.selectCount(cb);
    }

    public void delete(String sessionId) {
        AccessResultDataCB cb1 = new AccessResultDataCB();
        cb1.query().queryAccessResult().setSessionId_Equal(sessionId);
        this.accessResultDataBhv.queryDelete(cb1);
        String pmb = sessionId;
        int count = this.accessResultBhv.outsideSql().execute("deleteBySessionId", (Object)pmb);
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted urls in queue(deleteBySessionId): " + count);
        }
    }

    public void deleteAll() {
        Object pmb = null;
        int count = this.accessResultDataBhv.outsideSql().execute("deleteAll", pmb);
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted urls in queue(deleteAll): " + count);
        }
        count = this.accessResultBhv.outsideSql().execute("deleteBySessionId", pmb);
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted urls in queue(deleteBySessionId): " + count);
        }
    }

    public org.seasar.robot.entity.AccessResult getAccessResult(String sessionId, String url) {
        AccessResultCB cb = new AccessResultCB();
        cb.setupSelect_AccessResultDataAsOne();
        cb.query().setSessionId_Equal(sessionId);
        cb.query().setUrl_Equal(url);
        return this.accessResultBhv.selectEntity(cb);
    }

    public List<org.seasar.robot.entity.AccessResult> getAccessResultList(String url, boolean hasData) {
        AccessResultCB cb = new AccessResultCB();
        if (hasData) {
            cb.setupSelect_AccessResultDataAsOne();
        }
        cb.query().setUrl_Equal(url);
        cb.query().addOrderBy_CreateTime_Desc();
        ListResultBean<AccessResult> list = this.accessResultBhv.selectList(cb);
        ArrayList<org.seasar.robot.entity.AccessResult> accessResultList = new ArrayList<org.seasar.robot.entity.AccessResult>();
        accessResultList.addAll((Collection<org.seasar.robot.entity.AccessResult>)list);
        return accessResultList;
    }

    public void iterate(String sessionId, final AccessResultCallback accessResultCallback) {
        AccessResultCB cb = new AccessResultCB();
        cb.setupSelect_AccessResultDataAsOne();
        cb.query().setSessionId_Equal(sessionId);
        cb.query().addOrderBy_CreateTime_Asc();
        this.accessResultBhv.selectCursor(cb, new EntityRowHandler<AccessResult>(){

            public void handle(AccessResult entity) {
                accessResultCallback.iterate((org.seasar.robot.entity.AccessResult)entity);
            }
        });
    }

    public void iterateUrlDiff(String oldSessionId, String newSessionId, final AccessResultCallback accessResultCallback) {
        AccessResultPmb pmb = new AccessResultPmb();
        pmb.setOldSessionId(oldSessionId);
        pmb.setNewSessionId(newSessionId);
        AccessResultDiffCursorHandler handler = new AccessResultDiffCursorHandler(){

            public Object fetchCursor(AccessResultDiffCursor cursor) throws SQLException {
                while (cursor.next()) {
                    AccessResult accessResult = new AccessResult();
                    Beans.copy((Object)cursor, (Object)accessResult).execute();
                    accessResultCallback.iterate((org.seasar.robot.entity.AccessResult)accessResult);
                }
                return null;
            }
        };
        this.accessResultBhv.outsideSql().cursorHandling().selectCursor("selectListByUrlDiff", (Object)pmb, (CursorHandler)handler);
    }

    public void update(org.seasar.robot.entity.AccessResult accessResult) {
        this.accessResultBhv.update((AccessResult)accessResult);
        if (accessResult.getAccessResultData() != null) {
            this.accessResultDataBhv.update((AccessResultData)accessResult.getAccessResultData());
        }
    }

    public void update(List<org.seasar.robot.entity.AccessResult> accessResultList) {
        ArrayList<AccessResult> arList = new ArrayList<AccessResult>();
        ArrayList<AccessResultData> ardList = new ArrayList<AccessResultData>();
        for (org.seasar.robot.entity.AccessResult accessResult : accessResultList) {
            arList.add((AccessResult)accessResult);
            if (accessResult.getAccessResultData() == null) continue;
            ardList.add((AccessResultData)accessResult.getAccessResultData());
        }
        this.accessResultBhv.batchUpdate(arList);
        if (!ardList.isEmpty()) {
            this.accessResultDataBhv.batchUpdate(ardList);
        }
        for (org.seasar.robot.entity.AccessResult accessResult : accessResultList) {
            this.update(accessResult);
        }
    }
}

