/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jempbox.xmp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jempbox.impl.DateConverter;
import org.apache.jempbox.impl.XMLUtil;
import org.apache.jempbox.xmp.Elementable;
import org.apache.jempbox.xmp.ResourceEvent;
import org.apache.jempbox.xmp.Thumbnail;
import org.apache.jempbox.xmp.XMPMetadata;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMPSchema {
    public static final String NS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    protected String prefix;
    protected Element schema = null;

    public XMPSchema(XMPMetadata parent, String namespaceName, String namespaceURI) {
        this.schema = parent.xmpDocument.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Description");
        this.prefix = namespaceName;
        this.schema.setAttributeNS(NS_NAMESPACE, "xmlns:" + namespaceName, namespaceURI);
    }

    public XMPSchema(Element element, String aPrefix) {
        this.schema = element;
        this.prefix = aPrefix != null ? aPrefix : "";
    }

    public Element getElement() {
        return this.schema;
    }

    public String getAbout() {
        return this.getTextProperty("rdf:about");
    }

    public void setAbout(String about) {
        if (about == null) {
            this.schema.removeAttribute("rdf:about");
        } else {
            this.schema.setAttribute("rdf:about", about);
        }
    }

    public void setTextProperty(String propertyName, String propertyValue) {
        if (propertyValue == null) {
            this.schema.removeAttribute(propertyName);
            NodeList keywordList = this.schema.getElementsByTagName(propertyName);
            for (int i = 0; i < keywordList.getLength(); ++i) {
                this.schema.removeChild(keywordList.item(i));
            }
        } else if (this.schema.hasAttribute(propertyName)) {
            this.schema.setAttribute(propertyName, propertyValue);
        } else if (this.schema.hasChildNodes()) {
            NodeList nodeList = this.schema.getElementsByTagName(propertyName);
            if (nodeList.getLength() > 0) {
                Element node = (Element)nodeList.item(0);
                node.setNodeValue(propertyValue);
            } else {
                Element textNode = this.schema.getOwnerDocument().createElement(propertyName);
                XMLUtil.setStringValue(textNode, propertyValue);
                this.schema.appendChild(textNode);
            }
        } else {
            this.schema.setAttribute(propertyName, propertyValue);
        }
    }

    public String getTextProperty(String propertyName) {
        if (this.schema.hasAttribute(propertyName)) {
            return this.schema.getAttribute(propertyName);
        }
        NodeList nodes = this.schema.getElementsByTagName(propertyName);
        if (nodes.getLength() > 0) {
            Element node = (Element)nodes.item(0);
            return XMLUtil.getStringValue(node);
        }
        return null;
    }

    public Calendar getDateProperty(String propertyName) throws IOException {
        return DateConverter.toCalendar(this.getTextProperty(propertyName));
    }

    public void setDateProperty(String propertyName, Calendar date) {
        this.setTextProperty(propertyName, DateConverter.toISO8601(date));
    }

    public Boolean getBooleanProperty(String propertyName) {
        Boolean value = null;
        String stringValue = this.getTextProperty(propertyName);
        if (stringValue != null) {
            value = stringValue.equals("True") ? Boolean.TRUE : Boolean.FALSE;
        }
        return value;
    }

    public void setBooleanProperty(String propertyName, Boolean bool) {
        String value = null;
        if (bool != null) {
            value = bool != false ? "True" : "False";
        }
        this.setTextProperty(propertyName, value);
    }

    public Integer getIntegerProperty(String propertyName) {
        Integer retval = null;
        String intProperty = this.getTextProperty(propertyName);
        if (intProperty.equals("")) {
            retval = new Integer(intProperty);
        }
        return retval;
    }

    public void setIntegerProperty(String propertyName, Integer intValue) {
        String textValue = null;
        if (intValue != null) {
            textValue = intValue.toString();
        }
        this.setTextProperty(propertyName, textValue);
    }

    public void removeBagValue(String bagName, String bagValue) {
        Element contElement;
        NodeList bagList;
        Element bagElement = null;
        NodeList nodes = this.schema.getElementsByTagName(bagName);
        if (nodes.getLength() > 0 && (bagList = (contElement = (Element)nodes.item(0)).getElementsByTagName("rdf:Bag")).getLength() > 0) {
            bagElement = (Element)bagList.item(0);
            NodeList items = bagElement.getElementsByTagName("rdf:li");
            for (int i = items.getLength() - 1; i >= 0; --i) {
                Element li = (Element)items.item(i);
                String value = XMLUtil.getStringValue(li);
                if (!value.equals(bagValue)) continue;
                bagElement.removeChild(li);
            }
        }
    }

    public void addBagValue(String bagName, String bagValue) {
        Element contElement;
        Element bagElement = null;
        NodeList nodes = this.schema.getElementsByTagName(bagName);
        if (nodes.getLength() > 0) {
            contElement = (Element)nodes.item(0);
            NodeList bagList = contElement.getElementsByTagName("rdf:Bag");
            if (bagList.getLength() > 0) {
                bagElement = (Element)bagList.item(0);
            }
        } else {
            contElement = this.schema.getOwnerDocument().createElement(bagName);
            this.schema.appendChild(contElement);
            bagElement = this.schema.getOwnerDocument().createElement("rdf:Bag");
            contElement.appendChild(bagElement);
        }
        Element liElement = this.schema.getOwnerDocument().createElement("rdf:li");
        XMLUtil.setStringValue(liElement, bagValue);
        bagElement.appendChild(liElement);
    }

    public List getBagList(String bagName) {
        Element contributor;
        NodeList bagList;
        List<String> retval = null;
        NodeList nodes = this.schema.getElementsByTagName(bagName);
        if (nodes.getLength() > 0 && (bagList = (contributor = (Element)nodes.item(0)).getElementsByTagName("rdf:Bag")).getLength() > 0) {
            Element bag = (Element)bagList.item(0);
            retval = new ArrayList();
            NodeList items = bag.getElementsByTagName("rdf:li");
            for (int i = 0; i < items.getLength(); ++i) {
                Element li = (Element)items.item(i);
                retval.add(XMLUtil.getStringValue(li));
            }
            retval = Collections.unmodifiableList(retval);
        }
        return retval;
    }

    public void removeSequenceValue(String seqName, String seqValue) {
        Element contElement;
        NodeList bagList;
        Element bagElement = null;
        NodeList nodes = this.schema.getElementsByTagName(seqName);
        if (nodes.getLength() > 0 && (bagList = (contElement = (Element)nodes.item(0)).getElementsByTagName("rdf:Seq")).getLength() > 0) {
            bagElement = (Element)bagList.item(0);
            NodeList items = bagElement.getElementsByTagName("rdf:li");
            for (int i = items.getLength() - 1; i >= 0; --i) {
                Element li = (Element)items.item(i);
                String value = XMLUtil.getStringValue(li);
                if (!value.equals(seqValue)) continue;
                bagElement.removeChild(li);
            }
        }
    }

    public void removeSequenceValue(String seqName, Elementable seqValue) {
        Element contElement;
        NodeList bagList;
        Element bagElement = null;
        NodeList nodes = this.schema.getElementsByTagName(seqName);
        if (nodes.getLength() > 0 && (bagList = (contElement = (Element)nodes.item(0)).getElementsByTagName("rdf:Seq")).getLength() > 0) {
            bagElement = (Element)bagList.item(0);
            NodeList items = bagElement.getElementsByTagName("rdf:li");
            for (int i = 0; i < items.getLength(); ++i) {
                Element li = (Element)items.item(i);
                if (li != seqValue.getElement()) continue;
                bagElement.removeChild(li);
            }
        }
    }

    public void addSequenceValue(String seqName, String seqValue) {
        Element contElement;
        Element bagElement = null;
        NodeList nodes = this.schema.getElementsByTagName(seqName);
        if (nodes.getLength() > 0) {
            contElement = (Element)nodes.item(0);
            NodeList bagList = contElement.getElementsByTagName("rdf:Seq");
            if (bagList.getLength() > 0) {
                bagElement = (Element)bagList.item(0);
            } else {
                this.schema.removeChild(nodes.item(0));
            }
        }
        if (bagElement == null) {
            contElement = this.schema.getOwnerDocument().createElement(seqName);
            this.schema.appendChild(contElement);
            bagElement = this.schema.getOwnerDocument().createElement("rdf:Seq");
            contElement.appendChild(bagElement);
        }
        Element liElement = this.schema.getOwnerDocument().createElement("rdf:li");
        liElement.appendChild(this.schema.getOwnerDocument().createTextNode(seqValue));
        bagElement.appendChild(liElement);
    }

    public void addSequenceValue(String seqName, Elementable seqValue) {
        Element bagElement = null;
        NodeList nodes = this.schema.getElementsByTagName(seqName);
        if (nodes.getLength() > 0) {
            Element contElement = (Element)nodes.item(0);
            NodeList bagList = contElement.getElementsByTagName("rdf:Seq");
            if (bagList.getLength() > 0) {
                bagElement = (Element)bagList.item(0);
            }
        } else {
            Element contElement = this.schema.getOwnerDocument().createElement(seqName);
            this.schema.appendChild(contElement);
            bagElement = this.schema.getOwnerDocument().createElement("rdf:Seq");
            contElement.appendChild(bagElement);
        }
        bagElement.appendChild(seqValue.getElement());
    }

    public List getSequenceList(String seqName) {
        Element contributor;
        NodeList bagList;
        List<String> retval = null;
        NodeList nodes = this.schema.getElementsByTagName(seqName);
        if (nodes.getLength() > 0 && (bagList = (contributor = (Element)nodes.item(0)).getElementsByTagName("rdf:Seq")).getLength() > 0) {
            Element bag = (Element)bagList.item(0);
            retval = new ArrayList();
            NodeList items = bag.getElementsByTagName("rdf:li");
            for (int i = 0; i < items.getLength(); ++i) {
                Element li = (Element)items.item(i);
                retval.add(XMLUtil.getStringValue(li));
            }
            retval = Collections.unmodifiableList(retval);
        }
        return retval;
    }

    public List getEventSequenceList(String seqName) {
        Element contributor;
        NodeList bagList;
        List<ResourceEvent> retval = null;
        NodeList nodes = this.schema.getElementsByTagName(seqName);
        if (nodes.getLength() > 0 && (bagList = (contributor = (Element)nodes.item(0)).getElementsByTagName("rdf:Seq")).getLength() > 0) {
            Element bag = (Element)bagList.item(0);
            retval = new ArrayList();
            NodeList items = bag.getElementsByTagName("rdf:li");
            for (int i = 0; i < items.getLength(); ++i) {
                Element li = (Element)items.item(i);
                retval.add(new ResourceEvent(li));
            }
            retval = Collections.unmodifiableList(retval);
        }
        return retval;
    }

    public void removeSequenceDateValue(String seqName, Calendar date) {
        String dateAsString = DateConverter.toISO8601(date);
        this.removeSequenceValue(seqName, dateAsString);
    }

    public void addSequenceDateValue(String seqName, Calendar date) {
        String dateAsString = DateConverter.toISO8601(date);
        this.addSequenceValue(seqName, dateAsString);
    }

    public List getSequenceDateList(String seqName) throws IOException {
        List strings = this.getSequenceList(seqName);
        ArrayList<Calendar> retval = null;
        if (strings != null) {
            retval = new ArrayList<Calendar>();
            for (int i = 0; i < strings.size(); ++i) {
                retval.add(DateConverter.toCalendar((String)strings.get(i)));
            }
        }
        return retval;
    }

    public void setLanguageProperty(String propertyName, String language, String value) {
        NodeList nodes = this.schema.getElementsByTagName(propertyName);
        Element property = null;
        if (nodes.getLength() == 0) {
            if (value == null) {
                return;
            }
            property = this.schema.getOwnerDocument().createElement(propertyName);
            this.schema.appendChild(property);
        } else {
            property = (Element)nodes.item(0);
        }
        Element alt = null;
        NodeList altList = property.getElementsByTagName("rdf:Alt");
        if (altList.getLength() == 0) {
            if (value == null) {
                return;
            }
            alt = this.schema.getOwnerDocument().createElement("rdf:Alt");
            property.appendChild(alt);
        } else {
            alt = (Element)altList.item(0);
        }
        NodeList items = alt.getElementsByTagName("rdf:li");
        if (language == null) {
            language = "x-default";
        }
        boolean foundValue = false;
        for (int i = 0; i < items.getLength(); ++i) {
            Element li = (Element)items.item(i);
            if (value == null) {
                alt.removeChild(li);
                continue;
            }
            if (!language.equals(li.getAttribute("xml:lang"))) continue;
            foundValue = true;
            XMLUtil.setStringValue(li, value);
        }
        if (value != null && !foundValue) {
            Element li = this.schema.getOwnerDocument().createElement("rdf:li");
            li.setAttribute("xml:lang", language);
            XMLUtil.setStringValue(li, value);
            if (language.equals("x-default")) {
                alt.insertBefore(li, alt.getFirstChild());
            } else {
                alt.appendChild(li);
            }
        }
    }

    public String getLanguageProperty(String propertyName, String language) {
        Element property;
        NodeList altList;
        NodeList nodes;
        String retval = null;
        if (language == null) {
            language = "x-default";
        }
        if ((nodes = this.schema.getElementsByTagName(propertyName)).getLength() > 0 && (altList = (property = (Element)nodes.item(0)).getElementsByTagName("rdf:Alt")).getLength() > 0) {
            Element alt = (Element)altList.item(0);
            NodeList items = alt.getElementsByTagName("rdf:li");
            for (int i = 0; i < items.getLength() && retval == null; ++i) {
                Element li = (Element)items.item(i);
                String elementLanguage = li.getAttribute("xml:lang");
                if (!language.equals(elementLanguage)) continue;
                retval = XMLUtil.getStringValue(li);
            }
        }
        return retval;
    }

    public void setThumbnailProperty(String propertyName, String language, Thumbnail value) {
        NodeList nodes = this.schema.getElementsByTagName(propertyName);
        Element property = null;
        if (nodes.getLength() == 0) {
            if (value == null) {
                return;
            }
            property = this.schema.getOwnerDocument().createElement(propertyName);
            this.schema.appendChild(property);
        } else {
            property = (Element)nodes.item(0);
        }
        Element alt = null;
        NodeList altList = property.getElementsByTagName("rdf:Alt");
        if (altList.getLength() == 0) {
            if (value == null) {
                return;
            }
            alt = this.schema.getOwnerDocument().createElement("rdf:Alt");
            property.appendChild(alt);
        } else {
            alt = (Element)altList.item(0);
        }
        NodeList items = alt.getElementsByTagName("rdf:li");
        if (language == null) {
            language = "x-default";
        }
        boolean foundValue = false;
        for (int i = 0; i < items.getLength(); ++i) {
            Element li = (Element)items.item(i);
            if (value == null) {
                alt.removeChild(li);
                continue;
            }
            if (!language.equals(li.getAttribute("xml:lang"))) continue;
            foundValue = true;
            alt.replaceChild(li, value.getElement());
        }
        if (value != null && !foundValue) {
            Element li = value.getElement();
            li.setAttribute("xml:lang", language);
            if (language.equals("x-default")) {
                alt.insertBefore(li, alt.getFirstChild());
            } else {
                alt.appendChild(li);
            }
        }
    }

    public Thumbnail getThumbnailProperty(String propertyName, String language) {
        Element property;
        NodeList altList;
        NodeList nodes;
        Thumbnail retval = null;
        if (language == null) {
            language = "x-default";
        }
        if ((nodes = this.schema.getElementsByTagName(propertyName)).getLength() > 0 && (altList = (property = (Element)nodes.item(0)).getElementsByTagName("rdf:Alt")).getLength() > 0) {
            Element alt = (Element)altList.item(0);
            NodeList items = alt.getElementsByTagName("rdf:li");
            for (int i = 0; i < items.getLength() && retval == null; ++i) {
                Element li = (Element)items.item(i);
                String elementLanguage = li.getAttribute("xml:lang");
                if (!language.equals(elementLanguage)) continue;
                retval = new Thumbnail(li);
            }
        }
        return retval;
    }

    public List getLanguagePropertyLanguages(String propertyName) {
        Element property;
        NodeList altList;
        ArrayList<String> retval = new ArrayList<String>();
        NodeList nodes = this.schema.getElementsByTagName(propertyName);
        if (nodes.getLength() > 0 && (altList = (property = (Element)nodes.item(0)).getElementsByTagName("rdf:Alt")).getLength() > 0) {
            Element alt = (Element)altList.item(0);
            NodeList items = alt.getElementsByTagName("rdf:li");
            for (int i = 0; i < items.getLength(); ++i) {
                Element li = (Element)items.item(i);
                String elementLanguage = li.getAttribute("xml:lang");
                if (elementLanguage == null) {
                    retval.add("x-default");
                    continue;
                }
                retval.add(elementLanguage);
            }
        }
        return retval;
    }

    public void merge(XMPSchema xmpSchema) throws IOException {
        if (!xmpSchema.getClass().equals(this.getClass())) {
            throw new IOException("Can only merge schemas of the same type.");
        }
        NamedNodeMap attributes = xmpSchema.getElement().getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node a = attributes.item(i);
            String name = a.getNodeName();
            if (!name.startsWith(this.prefix)) continue;
            String newValue = xmpSchema.getTextProperty(name);
            this.setTextProperty(name, newValue);
        }
        NodeList nodes = xmpSchema.getElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node a = nodes.item(i);
            String name = a.getNodeName();
            if (!name.startsWith(this.prefix)) continue;
            if (a instanceof Element) {
                Element e = (Element)a;
                if (nodes.getLength() > 0) {
                    NodeList seqList = e.getElementsByTagName("rdf:Seq");
                    if (seqList.getLength() > 0) {
                        List newList = xmpSchema.getSequenceList(name);
                        List oldList = this.getSequenceList(name);
                        Iterator it = newList.iterator();
                        while (it.hasNext()) {
                            Object object = it.next();
                            if (oldList != null && oldList.contains(object)) continue;
                            this.addSequenceValue(name, (String)object);
                        }
                        continue;
                    }
                    NodeList bagList = e.getElementsByTagName("rdf:Bag");
                    if (bagList.getLength() > 0) {
                        List newList = xmpSchema.getBagList(name);
                        List oldList = this.getBagList(name);
                        Iterator it = newList.iterator();
                        while (it.hasNext()) {
                            Object object = it.next();
                            if (oldList != null && oldList.contains(object)) continue;
                            this.addBagValue(name, (String)object);
                        }
                        continue;
                    }
                }
            }
            String newValue = xmpSchema.getTextProperty(name);
            this.setTextProperty(name, newValue);
        }
    }
}

