/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.charset;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.mobylet.charset.MobyletDecoder;
import org.mobylet.charset.MobyletEncoder;
import org.mobylet.charset.codemap.MobyletAuCodeMap;

public class MobyletAuCharset
extends Charset {
    protected MobyletAuCharset() {
        super("x-mobylet-au", new String[0]);
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof MobyletAuCharset;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    public class Decoder
    extends MobyletDecoder {
        protected Decoder(Charset charset) {
            super(charset);
        }

        @Override
        protected char decodeEmojiDouble(int b1, int b2) {
            return MobyletAuCodeMap.toChar((b1 << 8) + b2);
        }

        @Override
        protected short getMaxEmojiFirstCode() {
            return 247;
        }

        @Override
        protected short getMinEmojiFirstCode() {
            return 243;
        }
    }

    public class Encoder
    extends MobyletEncoder {
        protected Encoder(Charset charset) {
            super(charset);
        }

        @Override
        protected byte[] encodeEmojiDouble(char c) {
            int bi = MobyletAuCodeMap.toByte(c);
            if (bi > 255) {
                byte[] b = new byte[]{(byte)((bi & 0xFF00) >> 8), (byte)(bi & 0xFF)};
                return b;
            }
            return new byte[]{(byte)bi};
        }

        @Override
        protected int getMaxEmojiCode() {
            return 60295;
        }

        @Override
        protected int getMinEmojiCode() {
            return 59649;
        }
    }
}

