/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.TestClassRunner;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class ParameterizedTestMethodTest {
    private Class<?> fClass;
    private int fErrorCount;

    public ParameterizedTestMethodTest(Class<?> class1, int errorCount) {
        this.fClass = class1;
        this.fErrorCount = errorCount;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return Arrays.asList({EverythingWrong.class, 21}, {SubWrong.class, 1}, {SubShadows.class, 0});
    }

    private List<Throwable> validateAllMethods(Class<?> clazz) {
        try {
            new TestClassRunner(clazz);
        }
        catch (InitializationError e) {
            return e.getCauses();
        }
        return Collections.emptyList();
    }

    @Test
    public void testFailures() throws Exception {
        List<Throwable> problems = this.validateAllMethods(this.fClass);
        Assert.assertEquals(this.fErrorCount, problems.size());
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(ParameterizedTestMethodTest.class);
    }

    public static class SubShadows
    extends SuperWrong {
        @Test
        public void notPublic() {
        }
    }

    public static class SubWrong
    extends SuperWrong {
        @Test
        public void justFine() {
        }
    }

    public static class SuperWrong {
        @Test
        void notPublic() {
        }
    }

    public static class EverythingWrong {
        private EverythingWrong() {
        }

        @BeforeClass
        public void notStaticBC() {
        }

        @BeforeClass
        static void notPublicBC() {
        }

        @BeforeClass
        public static int nonVoidBC() {
            return 0;
        }

        @BeforeClass
        public static void argumentsBC(int i) {
        }

        @BeforeClass
        public static void fineBC() {
        }

        @AfterClass
        public void notStaticAC() {
        }

        @AfterClass
        static void notPublicAC() {
        }

        @AfterClass
        public static int nonVoidAC() {
            return 0;
        }

        @AfterClass
        public static void argumentsAC(int i) {
        }

        @AfterClass
        public static void fineAC() {
        }

        @After
        public static void staticA() {
        }

        @After
        void notPublicA() {
        }

        @After
        public int nonVoidA() {
            return 0;
        }

        @After
        public void argumentsA(int i) {
        }

        @After
        public void fineA() {
        }

        @Before
        public static void staticB() {
        }

        @Before
        void notPublicB() {
        }

        @Before
        public int nonVoidB() {
            return 0;
        }

        @Before
        public void argumentsB(int i) {
        }

        @Before
        public void fineB() {
        }

        @Test
        public static void staticT() {
        }

        @Test
        void notPublicT() {
        }

        @Test
        public int nonVoidT() {
            return 0;
        }

        @Test
        public void argumentsT(int i) {
        }

        @Test
        public void fineT() {
        }
    }
}

