/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorState;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;
import org.apache.pdfbox.util.operator.SetNonStrokingCMYKColor;
import org.apache.pdfbox.util.operator.SetNonStrokingCalRGBColor;
import org.apache.pdfbox.util.operator.SetNonStrokingGrayColor;
import org.apache.pdfbox.util.operator.SetNonStrokingICCBasedColor;
import org.apache.pdfbox.util.operator.SetNonStrokingRGBColor;

public class SetNonStrokingSeparation
extends OperatorProcessor {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$pdfbox$util$operator$SetNonStrokingSeparation == null ? (class$org$apache$pdfbox$util$operator$SetNonStrokingSeparation = SetNonStrokingSeparation.class$("org.apache.pdfbox.util.operator.SetNonStrokingSeparation")) : class$org$apache$pdfbox$util$operator$SetNonStrokingSeparation));
    static /* synthetic */ Class class$org$apache$pdfbox$util$operator$SetNonStrokingSeparation;

    public void process(PDFOperator operator, List arguments) throws IOException {
        PDColorState colorInstance = this.context.getGraphicsState().getNonStrokingColor();
        PDColorSpace colorSpace = colorInstance.getColorSpace();
        List argList = arguments;
        if (colorSpace instanceof PDSeparation) {
            PDSeparation sep = (PDSeparation)colorSpace;
            colorSpace = sep.getAlternateColorSpace();
            argList = sep.getColorValues().toList();
        }
        if (colorSpace != null) {
            OperatorProcessor newOperator = null;
            if (colorSpace instanceof PDDeviceGray) {
                newOperator = new SetNonStrokingGrayColor();
            } else if (colorSpace instanceof PDDeviceRGB) {
                newOperator = new SetNonStrokingRGBColor();
            } else if (colorSpace instanceof PDDeviceCMYK) {
                newOperator = new SetNonStrokingCMYKColor();
            } else if (colorSpace instanceof PDICCBased) {
                newOperator = new SetNonStrokingICCBasedColor();
            } else if (colorSpace instanceof PDCalRGB) {
                newOperator = new SetNonStrokingCalRGBColor();
            } else if (colorSpace instanceof PDSeparation) {
                newOperator = new SetNonStrokingSeparation();
            }
            if (newOperator != null) {
                newOperator.setContext(this.getContext());
                ((OperatorProcessor)newOperator).process(operator, argList);
            } else {
                log.warn((Object)("Not supported colorspace " + colorSpace.getName() + " within operator " + operator.getOperation()));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

