/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.awt.geom.Rectangle2D;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.util.PDFTextStripperByArea;

public class PrintURLs {
    static /* synthetic */ Class class$org$apache$pdfbox$examples$pdmodel$PrintURLs;

    private PrintURLs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PDDocument doc = null;
        try {
            if (args.length != 1) {
                PrintURLs.usage();
            } else {
                doc = PDDocument.load(args[0]);
                List allPages = doc.getDocumentCatalog().getAllPages();
                for (int i = 0; i < allPages.size(); ++i) {
                    PDAnnotationLink link;
                    PDAnnotation annot;
                    int j;
                    PDFTextStripperByArea stripper = new PDFTextStripperByArea();
                    PDPage page = (PDPage)allPages.get(i);
                    List annotations = page.getAnnotations();
                    for (j = 0; j < annotations.size(); ++j) {
                        annot = (PDAnnotation)annotations.get(j);
                        if (!(annot instanceof PDAnnotationLink)) continue;
                        link = (PDAnnotationLink)annot;
                        PDRectangle rect = link.getRectangle();
                        float x = rect.getLowerLeftX();
                        float y = rect.getUpperRightY();
                        float width = rect.getWidth();
                        float height = rect.getHeight();
                        int rotation = page.findRotation();
                        if (rotation == 0) {
                            PDRectangle pageSize = page.findMediaBox();
                            y = pageSize.getHeight() - y;
                        } else if (rotation == 90) {
                            // empty if block
                        }
                        Rectangle2D.Float awtRect = new Rectangle2D.Float(x, y, width, height);
                        stripper.addRegion("" + j, awtRect);
                    }
                    stripper.extractRegions(page);
                    for (j = 0; j < annotations.size(); ++j) {
                        annot = (PDAnnotation)annotations.get(j);
                        if (!(annot instanceof PDAnnotationLink)) continue;
                        link = (PDAnnotationLink)annot;
                        PDAction action = link.getAction();
                        String urlText = stripper.getTextForRegion("" + j);
                        if (!(action instanceof PDActionURI)) continue;
                        PDActionURI uri = (PDActionURI)action;
                        System.out.println("Page " + (i + 1) + ":'" + urlText + "'=" + uri.getURI());
                    }
                }
            }
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    private static void usage() {
        System.err.println("usage: " + (class$org$apache$pdfbox$examples$pdmodel$PrintURLs == null ? (class$org$apache$pdfbox$examples$pdmodel$PrintURLs = PrintURLs.class$("org.apache.pdfbox.examples.pdmodel.PrintURLs")) : class$org$apache$pdfbox$examples$pdmodel$PrintURLs).getName() + " <input-file>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

