/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.seasar.robot.entity.AccessResult;
import org.seasar.robot.entity.UrlQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryDataHelper {
    protected volatile Map<String, Queue<UrlQueue>> urlQueueMap = new HashMap<String, Queue<UrlQueue>>();
    protected volatile Map<String, Map<String, AccessResult>> sessionMap = new HashMap<String, Map<String, AccessResult>>();

    public void clear() {
        this.urlQueueMap.clear();
        this.sessionMap.clear();
    }

    public synchronized Queue<UrlQueue> getUrlQueueList(String sessionId) {
        Queue<UrlQueue> urlQueueList = this.urlQueueMap.get(sessionId);
        if (urlQueueList == null) {
            urlQueueList = new LinkedList<UrlQueue>();
            this.urlQueueMap.put(sessionId, urlQueueList);
        }
        return urlQueueList;
    }

    public synchronized void addUrlQueueList(String sessionId, Queue<UrlQueue> urlQueueList) {
        this.urlQueueMap.put(sessionId, urlQueueList);
    }

    public synchronized void removeUrlQueueList(String sessionId) {
        this.urlQueueMap.remove(sessionId);
    }

    public synchronized void clearUrlQueueList() {
        this.urlQueueMap.clear();
    }

    public synchronized Map<String, AccessResult> getAccessResultMap(String sessionId) {
        Map<String, AccessResult> arMap = this.sessionMap.get(sessionId);
        if (arMap == null) {
            arMap = new HashMap<String, AccessResult>();
            this.sessionMap.put(sessionId, arMap);
        }
        return arMap;
    }

    public synchronized void deleteAccessResultMap(String sessionId) {
        this.sessionMap.remove(sessionId);
    }

    public synchronized void deleteAllAccessResultMap() {
        this.sessionMap.clear();
    }

    public synchronized List<AccessResult> getAccessResultList(String url) {
        ArrayList<AccessResult> acList = new ArrayList<AccessResult>();
        for (Map.Entry<String, Map<String, AccessResult>> entry : this.sessionMap.entrySet()) {
            AccessResult ar;
            if (entry.getValue() == null || (ar = entry.getValue().get(url)) == null) continue;
            acList.add(ar);
        }
        return acList;
    }
}

