/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.client.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.S2RobotContext;
import org.seasar.robot.client.S2RobotClient;
import org.seasar.robot.client.http.BasicAuthentication;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.RobotsTxt;
import org.seasar.robot.helper.ContentLengthHelper;
import org.seasar.robot.helper.RobotsTxtHelper;
import org.seasar.robot.util.CrawlingParameterUtil;
import org.seasar.robot.util.StreamUtil;
import org.seasar.robot.util.TemporaryFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsHttpClient
implements S2RobotClient {
    public static final String CONNECTION_TIMEOUT_PROPERTY = "connectionTimeout";
    public static final String MAX_TOTAL_CONNECTIONS_PROPERTY = "maxTotalConnections";
    public static final String STALE_CHECKING_ENABLED_PROPERTY = "staleCheckingEnabled";
    public static final String SO_TIMEOUT_PROPERTY = "soTimeout";
    public static final String LINGER_PROPERTY = "linger";
    public static final String PROXY_HOST_PROPERTY = "proxyHost";
    public static final String PROXY_PORT_PROPERTY = "proxyPort";
    public static final String PROXY_CREDENTIALS_PROPERTY = "proxyCredentials";
    public static final String USER_AGENT_PROPERTY = "userAgent";
    public static final String BASIC_AUTHENTICATIONS_PROPERTY = "basicAuthentications";
    private final Logger logger = LoggerFactory.getLogger(CommonsHttpClient.class);
    @Resource
    protected RobotsTxtHelper robotsTxtHelper;
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    public Integer connectionTimeout;
    public Integer maxTotalConnections;
    public Boolean staleCheckingEnabled;
    public Integer soTimeout;
    public Integer linger;
    public String cookiePolicy;
    public String userAgent = "S2Robot";
    @Deprecated
    public String userAgentForRobotsTxt = "S2Robot";
    protected volatile HttpClient httpClient;
    public String proxyHost;
    public Integer proxyPort;
    @Binding(bindingType=BindingType.MAY)
    public Credentials proxyCredentials;
    public int responseBodyInMemoryThresholdSize = 0x100000;
    private Map<String, Object> initParamMap;

    protected <T> T getInitParameter(String key, T defaultValue) {
        Object value;
        if (this.initParamMap != null && (value = this.initParamMap.get(key)) != null) {
            return (T)value;
        }
        return defaultValue;
    }

    protected synchronized void init() {
        BasicAuthentication[] siteCredentialList;
        String userAgent;
        Integer linger;
        Integer soTimeout;
        Boolean staleCheckingEnabled;
        Integer maxTotalConnections;
        if (this.httpClient != null) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Initializing " + CommonsHttpClient.class.getName());
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        Integer connectionTimeout = this.getInitParameter(CONNECTION_TIMEOUT_PROPERTY, this.connectionTimeout);
        if (connectionTimeout != null) {
            params.setConnectionTimeout(connectionTimeout.intValue());
        }
        if ((maxTotalConnections = this.getInitParameter(MAX_TOTAL_CONNECTIONS_PROPERTY, this.maxTotalConnections)) != null) {
            params.setMaxTotalConnections(maxTotalConnections.intValue());
        }
        if ((staleCheckingEnabled = this.getInitParameter(STALE_CHECKING_ENABLED_PROPERTY, this.staleCheckingEnabled)) != null) {
            params.setStaleCheckingEnabled(staleCheckingEnabled.booleanValue());
        }
        if ((soTimeout = this.getInitParameter(SO_TIMEOUT_PROPERTY, this.soTimeout)) != null) {
            params.setSoTimeout(soTimeout.intValue());
        }
        if ((linger = this.getInitParameter(LINGER_PROPERTY, this.linger)) != null) {
            params.setLinger(linger.intValue());
        }
        connectionManager.setParams(params);
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        String proxyHost = this.getInitParameter(PROXY_HOST_PROPERTY, this.proxyHost);
        Integer proxyPort = this.getInitParameter(PROXY_PORT_PROPERTY, this.proxyPort);
        if (proxyHost != null && proxyPort != null) {
            this.httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort.intValue());
            Credentials proxyCredentials = this.getInitParameter(PROXY_CREDENTIALS_PROPERTY, this.proxyCredentials);
            if (proxyCredentials != null) {
                this.httpClient.getState().setProxyCredentials(AuthScope.ANY, proxyCredentials);
            }
        }
        if (StringUtil.isNotBlank((String)(userAgent = this.getInitParameter(USER_AGENT_PROPERTY, this.userAgent)))) {
            this.httpClient.getParams().setParameter("http.useragent", (Object)userAgent);
        }
        HttpState httpState = this.httpClient.getState();
        for (BasicAuthentication basicAuthentication : siteCredentialList = this.getInitParameter(BASIC_AUTHENTICATIONS_PROPERTY, new BasicAuthentication[0])) {
            httpState.setCredentials(basicAuthentication.getAuthScope(), basicAuthentication.getCredentials());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRobotsTxt(String url) {
        block19: {
            if (StringUtil.isBlank((String)url)) {
                throw new RobotSystemException("url is null or empty.");
            }
            if (this.robotsTxtHelper == null) {
                return;
            }
            S2RobotContext robotContext = CrawlingParameterUtil.getRobotContext();
            if (robotContext == null) {
                return;
            }
            int idx = url.indexOf(47, url.indexOf("://") + 3);
            String hostUrl = idx >= 0 ? url.substring(0, idx) : url;
            String robotTxtUrl = hostUrl + "/robots.txt";
            if (robotContext.getRobotTxtUrlSet().contains(robotTxtUrl)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(robotTxtUrl + " is already visited.");
                }
                return;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Checking URL: " + robotTxtUrl);
            }
            robotContext.getRobotTxtUrlSet().add(robotTxtUrl);
            GetMethod getMethod = new GetMethod(robotTxtUrl);
            if (this.cookiePolicy != null) {
                getMethod.getParams().setCookiePolicy(this.cookiePolicy);
            }
            try {
                RobotsTxt.Directives directives;
                RobotsTxt robotsTxt;
                this.httpClient.executeMethod((HttpMethod)getMethod);
                int httpStatusCode = getMethod.getStatusCode();
                if (httpStatusCode != 200) break block19;
                Header contentLengthHeader = getMethod.getResponseHeader("Content-Length");
                if (contentLengthHeader != null) {
                    String value = contentLengthHeader.getValue();
                    try {
                        long maxLength;
                        long contentLength = Long.parseLong(value);
                        if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength("text/plain"))) {
                            throw new RobotCrawlAccessException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + robotTxtUrl);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((robotsTxt = this.robotsTxtHelper.parse(getMethod.getResponseBodyAsStream())) != null && (directives = robotsTxt.getDirectives(this.userAgentForRobotsTxt)) != null) {
                    for (String urlPattern : directives.getDisallows()) {
                        if (!StringUtil.isNotBlank((String)urlPattern)) continue;
                        urlPattern = this.convertRobotsTxtPathPattern(urlPattern);
                        robotContext.getUrlFilter().addExclude(hostUrl + urlPattern);
                    }
                }
            }
            catch (UnknownHostException e) {
                throw new RobotCrawlAccessException("Unknown host: " + robotTxtUrl, e);
            }
            catch (Exception e) {
                this.logger.warn("Could not parse " + robotTxtUrl, (Throwable)e);
            }
            finally {
                getMethod.releaseConnection();
            }
        }
    }

    protected String convertRobotsTxtPathPattern(String path) {
        String newPath = path.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
        if (!newPath.startsWith("/")) {
            newPath = ".*" + newPath;
        }
        if (!newPath.endsWith("$") && !newPath.endsWith(".*")) {
            newPath = newPath + ".*";
        }
        return newPath.replaceAll("\\.\\*\\.\\*", ".*");
    }

    @Override
    public ResponseData doGet(String url) {
        block34: {
            if (this.httpClient == null) {
                this.init();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Accessing " + url);
            }
            try {
                this.processRobotsTxt(url);
            }
            catch (RobotCrawlAccessException e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(e.getMessage());
                }
                if (!this.logger.isDebugEnabled()) break block34;
                this.logger.debug("Crawling Access Exception at " + url, (Throwable)e);
            }
        }
        GetMethod getMethod = new GetMethod(url);
        getMethod.setFollowRedirects(false);
        if (this.cookiePolicy != null) {
            getMethod.getParams().setCookiePolicy(this.cookiePolicy);
        }
        try {
            Header contentLengthHeader;
            long maxLength;
            int idx;
            this.httpClient.executeMethod((HttpMethod)getMethod);
            int httpStatusCode = getMethod.getStatusCode();
            if (httpStatusCode >= 300 && httpStatusCode < 400) {
                Header locationHeader = getMethod.getResponseHeader("location");
                if (locationHeader != null) {
                    ResponseData responseData = new ResponseData();
                    responseData.setRedirectLocation(locationHeader.getValue());
                    ResponseData responseData2 = responseData;
                    return responseData2;
                }
                this.logger.warn("Invalid redirect location at " + url);
            }
            File outputFile = File.createTempFile("s2robot-CommonsHttpClient-", ".out");
            outputFile.deleteOnExit();
            DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.responseBodyInMemoryThresholdSize, outputFile);
            StreamUtil.drain(getMethod.getResponseBodyAsStream(), (OutputStream)dfos);
            long contentLength = 0L;
            InputStream inputStream = null;
            if (dfos.isInMemory()) {
                inputStream = new ByteArrayInputStream(dfos.getData());
                contentLength = dfos.getData().length;
                if (!outputFile.delete()) {
                    this.logger.warn("Could not delete " + outputFile.getAbsolutePath());
                }
            } else {
                inputStream = new TemporaryFileInputStream(outputFile);
                contentLength = outputFile.length();
            }
            String contentType = null;
            Header contentTypeHeader = getMethod.getResponseHeader("Content-Type");
            if (contentTypeHeader != null && (idx = (contentType = contentTypeHeader.getValue()).indexOf(";")) > 0) {
                contentType = contentType.substring(0, idx);
            }
            if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength(contentType))) {
                throw new RobotCrawlAccessException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + url);
            }
            ResponseData responseData = new ResponseData();
            responseData.setMethod("GET");
            responseData.setUrl(url);
            responseData.setCharSet(getMethod.getResponseCharSet());
            responseData.setResponseBody(inputStream);
            responseData.setHttpStatusCode(httpStatusCode);
            for (Header header : getMethod.getResponseHeaders()) {
                responseData.addHeader(header.getName(), header.getValue());
            }
            if (contentType != null) {
                responseData.setMimeType(contentType);
            }
            if ((contentLengthHeader = getMethod.getResponseHeader("Content-Length")) != null) {
                String value = contentLengthHeader.getValue();
                try {
                    responseData.setContentLength(Long.parseLong(value));
                }
                catch (Exception e) {
                    responseData.setContentLength(contentLength);
                }
            } else {
                responseData.setContentLength(contentLength);
            }
            Header lastModifiedHeader = getMethod.getResponseHeader("Last-Modified");
            if (lastModifiedHeader != null) {
                String value = lastModifiedHeader.getValue();
                if (StringUtil.isNotBlank((String)value)) {
                    Date d = this.parseLastModified(value);
                    if (d != null) {
                        responseData.setLastModified(d);
                    } else {
                        responseData.setLastModified(new Date());
                    }
                }
            } else {
                responseData.setLastModified(new Date());
            }
            ResponseData responseData3 = responseData;
            return responseData3;
        }
        catch (UnknownHostException e) {
            throw new RobotCrawlAccessException("Unknown host: " + url, e);
        }
        catch (NoRouteToHostException e) {
            throw new RobotCrawlAccessException("No route to host: " + url, e);
        }
        catch (ConnectException e) {
            throw new RobotCrawlAccessException("Connection time out: " + url, e);
        }
        catch (RobotSystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RobotSystemException("Failed to access " + url, e);
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    protected Date parseLastModified(String value) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        try {
            return sdf.parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public void setInitParameterMap(Map<String, Object> params) {
        this.initParamMap = params;
    }
}

